package ru.yandex.bannerstorage.harvester.tardis.models.vh;

import java.util.UUID;

import javax.validation.constraints.NotNull;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Папка для контента в VH
 *
 * @author freakbelka
 */
public class Directory {
    @JsonProperty("comment")
    private String comment;
    @JsonProperty("content_type_id")
    private int contentTypeId;
    @JsonProperty("name")
    private String name;
    @JsonProperty("parent_uuid")
    private String parentUuid;
    @JsonProperty("yandex_id")
    private UUID yandexId;

    public Directory(@NotNull String comment,
            @NotNull int contentTypeId,
            @NotNull String name,
            @NotNull String parentUuid,
            @NotNull UUID yandexId)
    {
        this.comment = comment;
        this.contentTypeId = contentTypeId;
        this.name = name;
        this.parentUuid = parentUuid;
        this.yandexId = yandexId;
    }

    @Override
    public String toString() {
        return "Directory{" +
                "comment=" + comment +
                ", content_type_id='" + contentTypeId +
                ", name='" + name +
                ", parent_uuid='" + parentUuid +
                ", yandex_id='" + yandexId +
                '}';
    }

    public String getComment() {
        return comment;
    }

    public int getContentTypeId() {
        return contentTypeId;
    }

    public String getName() {
        return name;
    }

    public String getParentUuid() {
        return parentUuid;
    }

    public UUID getYandexId() {
        return yandexId;
    }

}
