package ru.yandex.bannerstorage.harvester.tardis.models.vh;

import java.io.IOException;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;

public class FaasAnswer {
    private String formatsJson;
    private int duration;

    transient private List<ConvertedVideo> convertedVideos;

    @JsonCreator
    public FaasAnswer(@JsonProperty("formats") String formats,
            @JsonProperty("duration") double duration)
            throws IOException
    {
        this.formatsJson = formats;
        this.duration = (int) Math.round(duration);
        if (this.formatsJson != null) {
            ObjectMapper jsonMapper = new ObjectMapper()
                    .configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            this.convertedVideos = jsonMapper.readValue(formatsJson, new TypeReference<List<ConvertedVideo>>() {
            });
        }
    }

    public String getFormatsJson() {
        return formatsJson;
    }

    public int getDuration() {
        return duration;
    }

    public List<ConvertedVideo> getConvertedVideos() {
        return convertedVideos;
    }
}
