package ru.yandex.bannerstorage.harvester.tardis.models.vh;

import javax.validation.constraints.NotNull;

import com.fasterxml.jackson.annotation.JsonProperty;

public class FaasCustomParameters {
    @JsonProperty("ffmpeg_output_format")
    private String ffmpegOutputFormat;

    @JsonProperty("ffmpeg_loudnorm")
    private boolean ffmpegLoudnorm;

    @JsonProperty("strm_embed_ready")
    private boolean strmEmbedReady;

    @JsonProperty("keep_aspect_ratio")
    private boolean keepAspectRatio;

    public FaasCustomParameters(
            @JsonProperty("ffmpeg_output_format") @NotNull String ffmpegOutputFormat,
            @JsonProperty("ffmpeg_loudnorm") @NotNull boolean ffmpegLoudnorm,
            @JsonProperty("strm_embed_ready") @NotNull boolean strmEmbedReady,
            @JsonProperty("keep_aspect_ratio") @NotNull boolean keepAspectRatio)
    {
        this.ffmpegOutputFormat = ffmpegOutputFormat;
        this.ffmpegLoudnorm = ffmpegLoudnorm;
        this.strmEmbedReady = strmEmbedReady;
        this.keepAspectRatio = keepAspectRatio;
    }

    @Override
    public String toString() {
        return "FaasCustomParameters{" +
                "ffmpeg_output_format=" + ffmpegOutputFormat +
                '}';
    }

    public String getFfmpegOutputFormat() {
        return ffmpegOutputFormat;
    }

    public boolean isFfmpegLoudnorm() {
        return ffmpegLoudnorm;
    }

    public boolean isStrmEmbedReady() {
        return strmEmbedReady;
    }

    public boolean isKeepAspectRatio() {
        return keepAspectRatio;
    }
}
