package ru.yandex.bannerstorage.harvester.tardis.models.vh;

import javax.validation.constraints.NotNull;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

public class InputStream {
    @JsonProperty("data")
    private String url;

    @JsonProperty("vod_provider_id")
    private String vodProviderId;

    @JsonProperty("status")
    private String status;

    @JsonProperty("faas_custom_parameters")
    private FaasCustomParameters faasCustomParameters;

    @JsonIgnore
    private FaasAnswer faasAnswer;

    @JsonCreator
    public InputStream(@JsonProperty("data") @NotNull String url,
            @JsonProperty("vod_provider_id") @NotNull String vodProviderId,
            @JsonProperty("status") @NotNull String status,
            @JsonProperty("faas_custom_parameters") @NotNull FaasCustomParameters faasCustomParameters,
            @JsonProperty("faas_answer") FaasAnswer faasAnswer)
    {
        this.url = url;
        this.vodProviderId = vodProviderId;
        this.status = status;
        this.faasCustomParameters = faasCustomParameters;
        this.faasAnswer = faasAnswer;
    }

    @Override
    public String toString() {
        return "InputStream{" +
                "data=" + url +
                ", vod_provider_id='" + vodProviderId + '\'' +
                ", status='" + status + '\'' +
                ", faas_custom_parameters='" + faasCustomParameters +
                '}';
    }

    public String getUrl() {
        return url;
    }

    public String getVodProviderId() {
        return vodProviderId;
    }

    public String getStatus() {
        return status;
    }

    public FaasCustomParameters getFaasCustomParameters() {
        return faasCustomParameters;
    }

    public FaasAnswer getFaasAnswer() {
        return faasAnswer;
    }

}
