package ru.yandex.bannerstorage.harvester.tardis.models.vh;

import java.util.Collections;
import java.util.List;

import javax.validation.constraints.NotNull;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Таск на загрузку в VH
 *
 * @author freakbelka
 */
public class Task {
    @JsonIgnore
    private static transient final String UPLOAD_STATUS = "faas-wait-for-add";

    @JsonProperty("name")
    private final String name;

    @JsonProperty("comment")
    private final String comment;

    @JsonProperty("content_versions")
    private final List<ContentVersions> contentVersions;

    @JsonProperty("parent_uuid")
    private final String parentUuid;

    @JsonProperty("content_type_id")
    private final int contentTypeId;

    public Task(@NotNull String name,
            String comment,
            @NotNull String parentUuid,
            @NotNull int contentTypeId,
            @NotNull String sourceUrl,
            @NotNull String vodProviderId,
            @NotNull String outputFormats)
    {
        this.name = name;
        this.comment = comment;
        this.parentUuid = parentUuid;
        this.contentTypeId = contentTypeId;
        this.contentVersions = Collections.singletonList(new ContentVersions(
                Collections.singletonList(new InputStream(sourceUrl, vodProviderId, UPLOAD_STATUS,
                        new FaasCustomParameters(outputFormats, true, true, true), null)), null, null));
    }

    @Override
    public String toString() {
        return "Task{" +
                "name=" + name +
                ", comment='" + comment + '\'' +
                ", content_versions='" + contentVersions + '\'' +
                ", parent_uuid='" + parentUuid +
                '}';
    }

    public String getName() {
        return name;
    }

    public String getComment() {
        return comment;
    }

    public List<ContentVersions> getContentVersions() {
        return contentVersions;
    }

    public String getParentUuid() {
        return parentUuid;
    }

    public int getContentTypeId() {
        return contentTypeId;
    }
}
