package ru.yandex.bannerstorage.harvester.utils;

import java.util.ArrayList;
import java.util.List;

import org.jetbrains.annotations.NotNull;

/**
 * @author egorovmv
 */
public final class IntegerUtils {
    private IntegerUtils() {
    }

    public static Integer parseIgnoreWhitespace(@NotNull String s, int startIndex, int endIndex) {
        while (Character.isWhitespace(s.charAt(startIndex))) {
            startIndex++;
        }
        //noinspection StatementWithEmptyBody
        while (startIndex < endIndex && Character.isWhitespace(s.charAt(--endIndex))) {
        }
        if (startIndex <= endIndex) {
            // Оптимизация по памяти
            if (startIndex != 0 || endIndex != s.length() - 1) {
                s = s.substring(startIndex, endIndex + 1);
            }
            return Integer.valueOf(s);
        }
        return null;
    }

    public static List<Integer> splitByChar(@NotNull String listOfIntegers, char separator) {
        List<Integer> result = new ArrayList<>();
        int startIndex = 0;
        int endIndex = listOfIntegers.indexOf(separator);
        while (startIndex < endIndex) {
            Integer value = IntegerUtils.parseIgnoreWhitespace(
                    listOfIntegers, startIndex, endIndex);
            if (value != null) {
                result.add(value);
            }
            startIndex = endIndex + 1;
            endIndex = listOfIntegers.indexOf(',', startIndex);
        }
        if (startIndex < listOfIntegers.length()) {
            Integer value = IntegerUtils.parseIgnoreWhitespace(
                    listOfIntegers, startIndex, listOfIntegers.length());
            if (value != null) {
                result.add(value);
            }
        }
        return result;
    }
}
