package ru.yandex.bannerstorage.harvester.utils;

import java.io.IOException;
import java.io.UncheckedIOException;

import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.common.base.Supplier;
import org.jetbrains.annotations.NotNull;

/**
 * @author egorovmv
 */
public final class JsonUtils {
    private JsonUtils() {
    }

    public static String serialize(@NotNull ObjectWriter writer, Object obj) {
        try {
            return writer.writeValueAsString(obj);
        } catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static <T> T deserialize(@NotNull ObjectReader reader, @NotNull String src) {
        try {
            return reader.readValue(src);
        } catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static <T> T deserialize(
            @NotNull ObjectReader reader, String src, @NotNull Supplier<T> defaultValue) {
        try {
            if (src == null)
                return defaultValue.get();
            return reader.readValue(src);
        } catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}
