package ru.yandex.bannerstorage.harvester.utils;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

/**
 * @author egorovmv
 */
public final class UriHelper {
    private UriHelper() {
    }

    public static URI fromString(String uri) {
        try {
            return new URI(Objects.requireNonNull(uri, "uri"));
        } catch (URISyntaxException e) {
            throw new UncheckedURISyntaxException(e);
        }
    }

    public static String encodeUriComponent(String uri) {
        try {
            return URLEncoder.encode(uri, StandardCharsets.UTF_8.name());
        } catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static final class UncheckedURISyntaxException extends RuntimeException {
        public UncheckedURISyntaxException(Throwable cause) {
            super(cause);
        }
    }
}
