package ru.yandex.bannerstorage.messaging;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;

import ru.yandex.bannerstorage.messaging.services.impl.QueueNotificationCallbackExecutor;

/**
 * @author egorovmv
 */
@Configuration
public class QueueNotificationCallbackExecutorConfig {
    @Bean
    @Profile("production")
    public QueueNotificationCallbackExecutor productionQueueNotificationCallbackExecutor() {
        return new QueueNotificationCallbackExecutor.Production();
    }

    @Bean
    @Profile("testing")
    public QueueNotificationCallbackExecutor testingQueueNotificationCallbackExecutor() {
        return new QueueNotificationCallbackExecutor.Testing();
    }
}
