package ru.yandex.bannerstorage.messaging;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;

import ru.yandex.bannerstorage.messaging.services.QueueProcessMessageScheduler;
import ru.yandex.bannerstorage.messaging.services.schedulers.ImmediateExecutionProcessMessageScheduler;
import ru.yandex.bannerstorage.messaging.services.schedulers.ScheduledExecutorProcessMessageScheduler;

/**
 * @author egorovmv
 */
@Configuration
public class QueueProcessMessageSchedulerConfig {
    @Bean
    @Profile("production")
    public QueueProcessMessageScheduler productionQueueProcessMessageScheduler(
            @Value("${bannerstorage.messaging.queueProcessMessageScheduler.queueId:9}") int waitTimeToCpuTime) {
        return new ScheduledExecutorProcessMessageScheduler(waitTimeToCpuTime);
    }

    @Bean
    @Profile("testing")
    public QueueProcessMessageScheduler testingQueueProcessMessageScheduler() {
        return new ImmediateExecutionProcessMessageScheduler();
    }
}
