package ru.yandex.bannerstorage.messaging.controllers;

import java.util.Collections;
import java.util.List;
import java.util.Objects;

import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import ru.yandex.bannerstorage.messaging.models.QueueMonitoringState;
import ru.yandex.bannerstorage.messaging.services.MessagingDispatcherService;

/**
 * @author egorovmv
 */
@RestController
@RequestMapping("api/internal/messaging/v1/queue")
public class QueueController {
    private static final String ALL_QUEUES_ID = "all";

    private final MessagingDispatcherService dispacherService;

    @Autowired
    public QueueController(@NotNull MessagingDispatcherService dispacherService) {
        this.dispacherService = Objects.requireNonNull(dispacherService, "dispacherService");
    }

    @RequestMapping(value = "{queueId:.+}", method = RequestMethod.GET)
    public List<QueueMonitoringState> getState(@NotNull @PathVariable("queueId") String queueId) {
        if (!queueId.equals(ALL_QUEUES_ID))
            return Collections.singletonList(dispacherService.getQueueMonitoringState(queueId));
        else
            return dispacherService.getQueuesMonitoringState();
    }

    @RequestMapping(value = "{queueId:.+}", method = RequestMethod.POST)
    public void wakeUp(@NotNull @PathVariable("queueId") String queueId) {
        if (!queueId.equals(ALL_QUEUES_ID))
            dispacherService.wakeUp(queueId);
        else
            dispacherService.wakeUpAll();
    }
}
