package ru.yandex.bannerstorage.messaging.models;

import org.jetbrains.annotations.NotNull;

/**
 * @author egorovmv
 */
public final class QueueMonitoringState {
    /**
     * Идентификатор очереди
     */
    private final String queueId;
    /**
     * Кол-во необработанных сообщений в очереди
     */
    private final int unprocessedCount;
    /**
     * Время нахождения в очереди последнего элемента
     */
    private final int maxWaitTimeInSecs;
    /**
     * Дата последней активности в формате Unix-time
     */
    private final long lastActivityUnixTime;

    public QueueMonitoringState(
            @NotNull String queueId, int unprocessedCount, int maxWaitTimeInSecs, long lastActivityUnixTime) {
        this.queueId = queueId;
        this.unprocessedCount = unprocessedCount;
        this.maxWaitTimeInSecs = maxWaitTimeInSecs;
        this.lastActivityUnixTime = lastActivityUnixTime;
    }

    public String getQueueId() {
        return queueId;
    }

    public int getUnprocessedCount() {
        return unprocessedCount;
    }

    public int getMaxWaitTimeInSecs() {
        return maxWaitTimeInSecs;
    }

    public long getLastActivityUnixTime() {
        return lastActivityUnixTime;
    }
}
