package ru.yandex.bannerstorage.messaging.services;

import java.util.Collections;
import java.util.Map;

import org.jetbrains.annotations.NotNull;

/**
 * @author egorovmv
 */
public interface QueueObserver extends AutoCloseable {
    int DEFAULT_INITIAL_START_DELAY_IN_SEC = 30;

    @NotNull
    String getQueueId();

    default int getInitialStartDelayInMS() {
        return DEFAULT_INITIAL_START_DELAY_IN_SEC;
    }

    int getPollIntervalInMS();

    default void start() {
    }

    default Map<String, Object> newLocalState() {
        return Collections.emptyMap();
    }

    boolean processMessages(
            @NotNull QueueOperations queueOperations, Map<String, Object> localState);

    @Override
    default void close() {
    }

    default boolean isRunning() {
        return true;
    }
}
