package ru.yandex.bannerstorage.messaging.services;

import org.jetbrains.annotations.NotNull;

/**
 * @author egorovmv
 */
public interface QueueOperations extends QueueMessageReceiver, QueueMessageSender {
    /**
     * Ответить асинхронно, на исходный асинхронные запрос
     *
     * @param message     Исходное сообщение запрос
     * @param messageType Тип ответного сообщения
     * @param reply       Тело ответного сообщения
     */
    void replyTo(
            @NotNull QueueMessage message, @NotNull String messageType, @NotNull String reply);

    /**
     * Отправить сообщение в специальную очередь для последующей перевставки в конец исходной очереди
     *
     * @param message              Исходное сообщение
     * @param isNewSessionRequired Открыть новую сессию при перевставке сообщения в исходную очередь?
     */
    void sendToPoisonMessageService(@NotNull QueueMessage message, boolean isNewSessionRequired);

    /**
     * Перевставить сообщение в конец очереди
     *
     * @param message Исходное сообщение
     */
    void reinsertInTheEnd(@NotNull QueueMessage message);

    /**
     * Завершить сессию в рамках которой было отправлено данное сообщение
     *
     * @param message
     */
    void endSession(QueueMessage message);
}
