package ru.yandex.bannerstorage.messaging.services;

import org.jetbrains.annotations.NotNull;

/**
 * @author egorovmv
 */
public interface QueueProcessMessageScheduler extends AutoCloseable {
    void startPolling(
            @NotNull Runnable processMessageCallback, long initialDelayInMS, long pollIntervalInMS);

    void reschedule(@NotNull Runnable processMessageCallback, long delayInMS);

    void submit(@NotNull Runnable processMessageCallback);

    @Override
    void close();
}
