package ru.yandex.bannerstorage.messaging.services;

import java.util.Objects;

import org.jetbrains.annotations.NotNull;

/**
 * @author egorovmv
 */
public final class ReplyQueueMessage<Reply> {
    private final String messageType;
    private final Reply reply;

    public ReplyQueueMessage(@NotNull String messageType, @NotNull Reply reply) {
        this.messageType = Objects.requireNonNull(messageType, "messageType");
        this.reply = Objects.requireNonNull(reply, "reply");
    }

    public String getMessageType() {
        return messageType;
    }

    public Reply getReply() {
        return reply;
    }
}
