package ru.yandex.bannerstorage.messaging.services;

import java.util.Objects;

import org.jetbrains.annotations.NotNull;

import ru.yandex.bannerstorage.messaging.utils.MessageSerializer;

/**
 * Наблюдатель очереди предназначенный для простых обработчиков ожидающих только один тип сообщения и не требующих
 * ответа
 */
public abstract class SimpleOneWayQueueObserver<T> extends AbstractQueueObserver {
    private final Class<T> messageClass;

    protected SimpleOneWayQueueObserver(
            @NotNull String queueId,
            int pollIntervalInMS,
            int batchSize,
            int threadsCount,
            @NotNull QueueMessageOnErrorStrategy errorStrategy,
            @NotNull Class<T> messageClass) {
        super(queueId, pollIntervalInMS, batchSize, threadsCount, errorStrategy);
        this.messageClass = Objects.requireNonNull(messageClass, "messageClass");
    }

    /**
     * Обработать заданное сообщение
     */
    protected abstract void doProcessMessage(@NotNull T message);

    @Override
    public final void doProcessMessage(@NotNull QueueOperations queueOperations, @NotNull QueueMessage message) {
        doProcessMessage(MessageSerializer.unmarshal(message.getPayload(), messageClass));
    }
}
