package ru.yandex.bannerstorage.messaging.services;

import java.util.Objects;

import org.jetbrains.annotations.NotNull;

import ru.yandex.bannerstorage.messaging.utils.MessageSerializer;

/**
 * Наблюдатель очереди предназначенный для простых обработчиков ожидающих только один тип сообщения и не требующих
 * ответа, в которых входные сообщения образуют непрерывный поток
 *
 * @author egorovmv
 */
public abstract class SimpleStreamQueueObserver<T> extends AbstractQueueObserver {
    private final Class<T> requestMessageClass;

    protected SimpleStreamQueueObserver(
            @NotNull String queueId,
            int pollIntervalInMS,
            int batchSize,
            int countOfThreads,
            @NotNull QueueMessageOnErrorStrategy errorStrategy,
            @NotNull Class<T> requestMessageClass) {
        super(queueId, pollIntervalInMS, batchSize, countOfThreads, errorStrategy);
        this.requestMessageClass = Objects.requireNonNull(requestMessageClass, "requestMessageClass");
    }

    /**
     * Обработать заданное сообщение
     */
    protected abstract void doProcessMessage(@NotNull T message);

    @Override
    public final void doProcessMessage(@NotNull QueueOperations queueOperations, @NotNull QueueMessage message) {
        doProcessMessage(MessageSerializer.unmarshal(message.getPayload(), requestMessageClass));
    }
}
