package ru.yandex.bannerstorage.messaging.services;

import java.util.Map;
import java.util.Objects;

import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author egorovmv
 */
public abstract class TimerQueueObserver implements QueueObserver {
    private final Logger logger;
    private final String queueId;
    private final int pollIntervalInMS;

    public TimerQueueObserver(@NotNull String queueId, int pollIntervalInMS) {
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.queueId = Objects.requireNonNull(queueId, "queueId");
        this.pollIntervalInMS = pollIntervalInMS;
    }

    @Override
    public @NotNull String getQueueId() {
        return queueId;
    }

    @Override
    public int getPollIntervalInMS() {
        return pollIntervalInMS;
    }

    @Override
    public final boolean processMessages(
            @NotNull QueueOperations queueOperations, Map<String, Object> localState) {
        logger.info("Begin process messages...");
        boolean result = OnTimer(localState);
        logger.info("End process messages");
        return result;
    }

    protected abstract boolean OnTimer(Map<String, Object> localState);
}
