package ru.yandex.bannerstorage.messaging.services.impl;

import java.util.function.Consumer;

import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Используется для отправки уведеомлений о новых сообщениях от {@link ru.yandex.bannerstorage.messaging.services.NotificationQueueWatcher}
 * к очередям управляемым {@link ru.yandex.bannerstorage.messaging.services.MessagingDispatcherService}
 *
 * @author egorovmv
 */
public interface QueueNotificationCallbackExecutor {
    void execute(@NotNull Consumer<String> notificationCallback, @NotNull String queueId);

    class Production implements QueueNotificationCallbackExecutor {
        private static final Logger LOGGER = LoggerFactory.getLogger(QueueNotificationCallbackExecutor.class);

        @Override
        public void execute(@NotNull Consumer<String> notificationCallback, @NotNull String queueId) {
            LOGGER.info("Sending wake up message to queue \"{}\"", queueId);

            notificationCallback.accept(queueId);

            LOGGER.info("Wake up message to queue \"{}\" sent", queueId);
        }
    }

    class Testing implements QueueNotificationCallbackExecutor {
        private static final Logger LOGGER = LoggerFactory.getLogger(QueueNotificationCallbackExecutor.class);

        @Override
        public void execute(@NotNull Consumer<String> notificationCallback, @NotNull String queueId) {
            LOGGER.info("Skip sending wake up message to queue \"{}\"", queueId);
        }
    }
}
