package ru.yandex.bannerstorage.messaging.services.impl;

import java.util.Objects;

import org.jetbrains.annotations.NotNull;

/**
 * @author egorovmv
 */
public final class ServiceBrokerNotificationQueueWatcherSettings {
    private final String notificationQueueId;
    private final int batchSize;
    private final int receiveTimeoutInMS;
    private final int sleepIntervalInMS;

    public ServiceBrokerNotificationQueueWatcherSettings(
            @NotNull String notificationQueueId,
            int batchSize,
            int receiveTimeoutInMS,
            int sleepIntervalInMS) {
        Objects.requireNonNull(notificationQueueId, "notificationQueueId");
        if (batchSize <= 0)
            throw new IllegalArgumentException("batchSize");
        if (receiveTimeoutInMS <= 0)
            throw new IllegalArgumentException("receiveTimeoutInMS");
        if (sleepIntervalInMS < 0)
            throw new IllegalArgumentException("sleepIntervalInMS");

        this.notificationQueueId = notificationQueueId;
        this.batchSize = batchSize;
        this.receiveTimeoutInMS = receiveTimeoutInMS;
        this.sleepIntervalInMS = sleepIntervalInMS;
    }

    public String getNotificationQueueId() {
        return notificationQueueId;
    }

    public int getBatchSize() {
        return batchSize;
    }

    public int getReceiveTimeoutInMS() {
        return receiveTimeoutInMS;
    }

    public int getSleepIntervalInMS() {
        return sleepIntervalInMS;
    }
}
