package ru.yandex.bannerstorage.messaging.services.impl;

import java.sql.Timestamp;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

import org.jetbrains.annotations.NotNull;

import ru.yandex.bannerstorage.messaging.services.QueueMessage;

/**
 * @author egorovmv
 */
@XmlRootElement(name = "poison_message")
@XmlAccessorType(XmlAccessType.FIELD)
public final class ServiceBrokerPoisonMessage implements QueueMessage {
    @XmlAttribute
    private String conversationId;
    @XmlAttribute
    private String serviceName;
    @XmlAttribute
    private String contractName;
    @XmlAttribute
    private String messageId;
    @XmlAttribute
    private String messageType;
    @XmlAttribute
    private long enqueuedTime;
    @XmlElement
    private String payload;
    @XmlAttribute
    private int retryCount;
    @XmlAttribute
    private boolean newSessionRequired;

    // Для сериализации
    private ServiceBrokerPoisonMessage() {
    }

    private ServiceBrokerPoisonMessage(
            @NotNull String conversationId,
            @NotNull String serviceName,
            @NotNull String contractName,
            @NotNull String messageId,
            @NotNull String messageType,
            @NotNull Timestamp enqueuedTime,
            String payload,
            int retryCount,
            boolean newSessionRequired) {
        this.conversationId = conversationId;
        this.serviceName = serviceName;
        this.contractName = contractName;
        this.messageId = messageId;
        this.messageType = messageType;
        this.enqueuedTime = enqueuedTime.getTime();
        this.payload = payload;
        this.retryCount = retryCount;
        this.newSessionRequired = newSessionRequired;
    }

    public static ServiceBrokerPoisonMessage fromQueueMessage(
            @NotNull ServiceBrokerQueueMessage message, boolean isNewSessionRequired) {
        return new ServiceBrokerPoisonMessage(
                message.getConversationId(),
                message.getServiceName(),
                message.getContractName(),
                message.getMessageId(),
                message.getMessageType(),
                message.getEnqueuedTime(),
                message.getPayload(),
                message.getRetryCount(),
                isNewSessionRequired);
    }

    @Override
    public String toString() {
        return "ServiceBrokerPoisonMessage{" +
                "conversationId='" + conversationId + '\'' +
                ", serviceName='" + serviceName + '\'' +
                ", contractName='" + contractName + '\'' +
                ", messageId='" + messageId + '\'' +
                ", messageType='" + messageType + '\'' +
                ", enqueuedTime=" + enqueuedTime +
                ", payload='" + payload + '\'' +
                ", retryCount=" + retryCount +
                ", newSessionRequired=" + newSessionRequired +
                '}';
    }

    public String getConversationId() {
        return conversationId;
    }

    public String getServiceName() {
        return serviceName;
    }

    public String getContractName() {
        return contractName;
    }

    @Override
    public String getMessageId() {
        return messageId;
    }

    @Override
    public String getMessageType() {
        return messageType;
    }

    @Override
    public Timestamp getEnqueuedTime() {
        return new Timestamp(enqueuedTime);
    }

    @Override
    public String getPayload() {
        return payload;
    }

    @Override
    public int getRetryCount() {
        return retryCount;
    }

    public boolean isNewSessionRequired() {
        return newSessionRequired;
    }
}
