package ru.yandex.bannerstorage.messaging.services.impl;

import org.jetbrains.annotations.NotNull;

import ru.yandex.bannerstorage.messaging.services.AbstractQueueObserver;
import ru.yandex.bannerstorage.messaging.services.QueueMessage;
import ru.yandex.bannerstorage.messaging.services.QueueMessageOnErrorStrategy;
import ru.yandex.bannerstorage.messaging.services.QueueOperations;
import ru.yandex.bannerstorage.messaging.services.ReceiveMessageStrategy;
import ru.yandex.bannerstorage.messaging.utils.MessageSerializer;

/**
 * Слушатель очереди PoisonMessageServiceQueue. Используется для перевставки плохих сообщений
 *
 * @author egorovmv
 */
public final class ServiceBrokerPoisonMessageQueueObserver extends AbstractQueueObserver {
    public ServiceBrokerPoisonMessageQueueObserver(@NotNull String queueId, int pollIntervalInMS) {
        super(queueId, pollIntervalInMS, 1, QueueMessageOnErrorStrategy.DEFAULT, ReceiveMessageStrategy.SNAPSHOT);
    }

    @Override
    protected void doProcessMessage(@NotNull QueueOperations queueOperations, @NotNull QueueMessage message) {
        ServiceBrokerPoisonMessage poisonMessage = MessageSerializer.unmarshal(
                message.getPayload(), ServiceBrokerPoisonMessage.class);
        queueOperations.reinsertInTheEnd(poisonMessage);
        queueOperations.endSession(message);
    }
}
