package ru.yandex.bannerstorage.messaging.services.impl;

import java.sql.Timestamp;
import java.util.Objects;

import org.jetbrains.annotations.NotNull;

import ru.yandex.bannerstorage.messaging.services.QueueMessage;

/**
 * @author egorovmv
 */
public final class ServiceBrokerQueueMessage implements QueueMessage {
    private final String conversationId;
    private final String serviceName;
    private final String contractName;
    private final String messageId;
    private final String messageType;
    private final Timestamp enqueuedTime;
    private final String payload;
    private final int retryCount;

    public ServiceBrokerQueueMessage(
            @NotNull String conversationId,
            @NotNull String serviceName,
            @NotNull String contractName,
            @NotNull String messageId,
            @NotNull String messageType,
            @NotNull Timestamp enqueuedTime,
            String payload,
            int retryCount) {
        this.conversationId = Objects.requireNonNull(conversationId, "conversationId");
        this.serviceName = Objects.requireNonNull(serviceName, "serviceName");
        this.contractName = Objects.requireNonNull(contractName, "contractName");
        this.messageId = Objects.requireNonNull(messageId, "messageId");
        this.messageType = Objects.requireNonNull(messageType, "messageType");
        this.enqueuedTime = Objects.requireNonNull(enqueuedTime, "enqueuedTime");
        this.payload = payload;
        this.retryCount = retryCount;
    }

    public String getConversationId() {
        return conversationId;
    }

    public String getServiceName() {
        return serviceName;
    }

    public String getContractName() {
        return contractName;
    }

    @Override
    public String getMessageId() {
        return messageId;
    }

    @Override
    public String getMessageType() {
        return messageType;
    }

    @Override
    public Timestamp getEnqueuedTime() {
        return enqueuedTime;
    }

    @Override
    public String getPayload() {
        return payload;
    }

    @Override
    public int getRetryCount() {
        return retryCount;
    }
}
