package ru.yandex.bannerstorage.messaging.services.impl;

import java.util.Objects;

import org.jetbrains.annotations.NotNull;
import org.springframework.jdbc.core.JdbcTemplate;

import ru.yandex.bannerstorage.messaging.models.QueueMonitoringState;
import ru.yandex.bannerstorage.messaging.services.QueueStateProvider;

/**
 * @author egorovmv
 */
public final class ServiceBrokerQueueStateProvider implements QueueStateProvider {
    private final JdbcTemplate jdbcTemplate;

    public ServiceBrokerQueueStateProvider(@NotNull JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = Objects.requireNonNull(jdbcTemplate, "jdbcTemplate");
    }

    private static String createSqlQuery(String queueId) {
        // Так как queueId задается внутри, то поставляем в код SQL напрямую
        return String.format(
                "SELECT unprocessedCount, COALESCE(maxWaitTimeInSec, 0) as maxWaitTimeInSec" +
                        " FROM (SELECT COUNT(*) AS unprocessedCount FROM %1$s WITH(NOLOCK)) as t1" +
                        " OUTER APPLY (" +
                        "   SELECT TOP(1)" +
                        "       DATEDIFF(" +
                        "           second," +
                        "           CAST(message_body AS xml).value('(/message/@enqueued)[1]', 'datetime')," +
                        "           GETDATE()) AS maxWaitTimeInSec" +
                        "       FROM %1$s WITH(NOLOCK)) as t2",
                queueId);
    }

    @Override
    public QueueMonitoringState getStateOf(@NotNull String queueId) {
        return jdbcTemplate.queryForObject(
                createSqlQuery(queueId),
                (rs, i) -> new QueueMonitoringState(queueId, rs.getInt(1), rs.getInt(2), 0));
    }
}
