package ru.yandex.bannerstorage.messaging.services.schedulers;

import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.bannerstorage.messaging.services.QueueProcessMessageScheduler;

/**
 * @author egorovmv
 */
public final class ImmediateExecutionProcessMessageScheduler implements QueueProcessMessageScheduler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImmediateExecutionProcessMessageScheduler.class);

    @Override
    public void startPolling(
            @NotNull Runnable processMessageCallback, long initialDelayInMS, long pollIntervalInMS) {
    }

    @Override
    public void reschedule(@NotNull Runnable processMessageCallback, long delayInMS) {
    }

    @Override
    public void submit(@NotNull Runnable processMessageCallback) {
        try {
            processMessageCallback.run();
        } catch (Exception e) {
            LOGGER.error("Can't process messages", e);
        }
    }

    @Override
    public void close() {
    }
}
