JAVA_PROGRAM(bannerstorage-harvester)
INCLUDE(${ARCADIA_ROOT}/direct/libs/common.inc)

EXCLUDE (
    # Эти две библиотеки приезжают из spring-boot-starter-logging и мешают работе log4j-slf4j-impl
    contrib/java/ch/qos/logback/logback-classic
    contrib/java/org/apache/logging/log4j/log4j-to-slf4j
    contrib/java/org/springframework/boot/spring-boot-starter-tomcat
)

JVM_ARGS(
    # java-8 не должна падать от опций java-9
    -XX:+IgnoreUnrecognizedVMOptions
    --illegal-access=warn
)

SET(spring_boot_version 2.1.4.RELEASE)


DEPENDENCY_MANAGEMENT(
    contrib/java/net/sourceforge/jtds/jtds/1.3.1
    contrib/java/javax/inject/javax.inject/1
    contrib/java/org/apache/commons/commons-dbcp2/2.8.0
    contrib/java/org/apache/httpcomponents/httpclient/4.5.13
    contrib/java/org/jsoup/jsoup/1.8.3
    contrib/java/org/json/json/20160212

    contrib/java/org/springframework/boot/spring-boot-starter-jdbc/${spring_boot_version}
    contrib/java/org/springframework/boot/spring-boot-starter-mail/${spring_boot_version}
)

PEERDIR(
    contrib/java/org/apache/commons/commons-lang3
    contrib/java/org/jetbrains/annotations
    contrib/java/org/slf4j/slf4j-api
    contrib/java/com/google/guava/guava
    contrib/java/org/springframework/spring-core
    contrib/java/org/springframework/spring-jdbc
    contrib/java/org/springframework/spring-webmvc

    # Нужно для MessageSerializer
    contrib/java/javax/xml/bind/jaxb-api
    contrib/java/org/glassfish/jaxb/jaxb-runtime

    contrib/java/com/fasterxml/jackson/core/jackson-databind
    contrib/java/com/fasterxml/jackson/datatype/jackson-datatype-jsr310
    contrib/java/net/sourceforge/jtds/jtds
    contrib/java/javax/inject/javax.inject
    contrib/java/org/apache/commons/commons-dbcp2
    contrib/java/org/apache/httpcomponents/httpclient
    contrib/java/org/apache/logging/log4j/log4j-api
    contrib/java/org/apache/logging/log4j/log4j-core
    contrib/java/org/apache/logging/log4j/log4j-slf4j-impl
    contrib/java/org/jsoup/jsoup
    contrib/java/org/json/json

    contrib/java/org/springframework/boot/spring-boot
    contrib/java/org/springframework/boot/spring-boot-autoconfigure
    contrib/java/org/springframework/boot/spring-boot-starter
    contrib/java/org/springframework/boot/spring-boot-starter-aop
    contrib/java/org/springframework/boot/spring-boot-starter-jetty
    contrib/java/org/springframework/boot/spring-boot-starter-jdbc
    contrib/java/org/springframework/boot/spring-boot-starter-web
    contrib/java/org/springframework/boot/spring-boot-starter-mail

    direct/libs-internal/bs-dsp-creative
    direct/libs-internal/screenshooter
)

JAVA_SRCS(SRCDIR src/main/java **/*)
JAVA_SRCS(SRCDIR src/main/resources **/*)

END()

RECURSE_FOR_TESTS(
    ut
)
