package ru.yandex;

import javax.servlet.*;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.sql.DataSource;
import java.io.IOException;
import java.sql.*;
import java.util.Hashtable;
import java.util.UUID;

/**
 * @author elwood
 */
public class AuthFilter implements Filter {
    private final DataSource dataSource;

    private AuthFilter(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    @Override
    public void doFilter(ServletRequest servletRequest,
                         ServletResponse servletResponse,
                         FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest) servletRequest;
        HttpServletResponse response = (HttpServletResponse) servletResponse;

        String requestURI = request.getRequestURI();
        if (requestURI.equals("/Login.jsp")
                || requestURI.startsWith("/include/")
                || requestURI.equals("/favicon.ico")
                || requestURI.equals("/servlet/com.digillect.servlet.Picture")
                || requestURI.equals("/authorise")
                || requestURI.equals("/ping")) {
            chain.doFilter(request, response);
            return;
        }

        HttpSession session = request.getSession();

        Hashtable user = (Hashtable) session.getValue("user");

        try (Connection db = dataSource.getConnection()) {
            // Пользователя нет в сессии, значит либо сессия истекла, либо несанкционированный доступ
            if (user == null) {
                int i, ok = 0;
                user = new Hashtable();

                // Day login -->
                Cookie[] cks = request.getCookies();
                String cname, login_key = "00000000-0000-0000-0000-000000000003";

                if (cks != null) {
                    for (i = 0; i < cks.length; i++) {
                        cname = cks[i].getName();
                        if (cname.equals("login_key")) {
                            String testLoginKey = cks[i].getValue();
                            try {
                                UUID.fromString(testLoginKey);
                                login_key = testLoginKey;
                            } catch (IllegalArgumentException e) {
                                // Invalid login_key stored in cookie, ignore it
                            }
                            break;
                        }
                    }
                }

                String req = "exec sp_user_ 'authorise', @login_key = ?";
                try (PreparedStatement pstmt = db.prepareStatement(req)) {
                    pstmt.setString(1, login_key);

                    try (ResultSet rs = pstmt.executeQuery()) {
                        if (rs.next()) {
                            String user_id = rs.getString("id");
                            String full_name = rs.getString("full_name");
                            String RUEN = rs.getString("RUEN");
                            ok = rs.getInt("ok");
                            if (ok != 0) {
                                user.put("user_id", user_id);
                                user.put("full_name", full_name);
                                user.put("RUEN", RUEN);
                            }
                        }
                    }

                    if (ok != 0) {
                        if (pstmt.getMoreResults()) {
                            try (ResultSet rs = pstmt.getResultSet()) {
                                while (rs.next()) {
                                    String symbol = rs.getString("symbol");
                                    user.put(symbol, "ok");
                                }
                            }
                        }
                        session.putValue("user", user);
                    }
                }

                // Day login
                if (ok == 0) {
                    String checkPermThisURL = requestURI + ((request.getQueryString() != null) ? ("?" + request.getQueryString()) : "");
                    // Fix return url
                    if (checkPermThisURL.startsWith("/WEB-INF/jsp")) {
                        checkPermThisURL = checkPermThisURL.substring("/WEB-INF/jsp".length());
                    }
                    session.putValue("returnURL", checkPermThisURL);
                    response.sendRedirect(String.format("%s://%s/Login.jsp", PropertiesProvider.getSheme(), request.getServerName()));
                    return;
                }
            }
        } catch (SQLException e) {
            throw new RuntimeException(e);
        }
        chain.doFilter(request, response);
    }

    @Override
    public void destroy() {
    }
}
