package ru.yandex;

import java.net.URL;
import java.util.List;

/**
 * Created by freakbelka on 05.05.17.
 */
public class CheckResult {

    private final URL resultUrl;
    private final List<String> failedUrls;

    public CheckResult(List<String> failedUrls, URL resultUrl) {
        this.failedUrls = failedUrls;
        this.resultUrl = resultUrl;
    }

    public URL getResultUrl() {
        return this.resultUrl;
    }

    public boolean hasErrors() {
        return failedUrls != null && !failedUrls.isEmpty();
    }

    public List<String> getFailedUrls() {
        return failedUrls;
    }
}
