package ru.yandex;

import net.yandex.bannerstorage.service.RedirectChain;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

/**
 * @author freakbelka
 */
public class CheckerAsyncResult {
    private static final Logger LOGGER = LoggerFactory.getLogger(CheckerAsyncResult.class);
    private static final int TIMEOUT_SEC = 20;
    public CheckerAsyncResult(List<CompletableFuture<RedirectChain>> futures, List<String> failedUrls, String originalUrl) {
        this.futures = futures;
        this.failedUrls = failedUrls;
        this.originalUrl = originalUrl;
    }

    private List<CompletableFuture<RedirectChain>> futures;
    private List<String> failedUrls;
    private String originalUrl;

    public CheckResult get() {
        if (!this.failedUrls.isEmpty()) {
            return new CheckResult(this.failedUrls, null);
        }

        try {
            if (this.futures.size() == 2) {
                return checkTwoFutures();
            }

            if (this.futures.size() == 1) {
                return checkOneFuture();
            }

            return new CheckResult(Collections.singletonList(originalUrl), null);


        } catch (MalformedURLException | InterruptedException | ExecutionException | TimeoutException e) {
            LOGGER.warn("can't get end point url: " + e.getClass().getName() + " : " + e.getMessage());
            return new CheckResult(Collections.singletonList(originalUrl), null);
        }
    }

    @NotNull
    private CheckResult checkOneFuture() throws InterruptedException, ExecutionException, MalformedURLException, TimeoutException {
        String endPoint = this.futures.get(0).get(TIMEOUT_SEC, TimeUnit.SECONDS).getEndPoint();
        if (endPoint == null) {
            return new CheckResult(Collections.singletonList(originalUrl), null);
        }
        return new CheckResult(Collections.emptyList(), new URL(endPoint));
    }

    @NotNull
    private CheckResult checkTwoFutures() throws InterruptedException, ExecutionException, MalformedURLException, TimeoutException {
        String endPoint1 = this.futures.get(0).get(TIMEOUT_SEC, TimeUnit.SECONDS).getEndPoint();
        String endPoint2 = this.futures.get(1).get(TIMEOUT_SEC, TimeUnit.SECONDS).getEndPoint();
        if (endPoint1 == null || endPoint2 == null) {
            return new CheckResult(Collections.singletonList(originalUrl), null);
        }
        String host1 = new URL(endPoint1).getHost();
        String host2 = new URL(endPoint2).getHost();
        if (host1.equals(host2)) {
            return new CheckResult(Collections.emptyList(), new URL(endPoint1));
        } else {
            return new CheckResult(Collections.singletonList(originalUrl), null);
        }
    }
}
