package ru.yandex;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

/**
 * @author elwood
 */
public class Html5Utils {
    public static class WidthHeight {
        private final int width;
        private final int height;

        public WidthHeight(int width, int height) {
            this.width = width;
            this.height = height;
        }

        public int getWidth() {
            return width;
        }

        public int getHeight() {
            return height;
        }
    }

    /**
     * Получает width и height для указанного HTML5-параметра креатива.
     * parameterName - название параметра (либо просто HTML5_FILE, либо с суффиксом, например, HTML5_FILE_SMALL).
     */
    public static WidthHeight getHtml5WidthHeight(Connection connection,
                                                  int creativeVersionNmb,
                                                  String parameterName) {
        if (!parameterName.startsWith("HTML5_FILE")) {
            throw new IllegalArgumentException("parameterName should start from 'HTML5_FILE'");
        }
        int width = 0;
        int height = 0;
        try (PreparedStatement statement = connection.prepareStatement(
                "select p.name, pv.value_int" +
                        " from dbo.t_creative_version_param_value pv with (nolock)" +
                        "  join dbo.t_parameter p with (nolock) on pv.parameter_nmb = p.nmb" +
                        " where pv.creative_version_nmb = ?" +
                        "  and p.name in (?, ?)")) {
            statement.setInt(1, creativeVersionNmb);
            String suffix = parameterName.substring("HTML5_FILE".length());
            statement.setString(2, "WIDTH" + suffix);
            statement.setString(3, "HEIGHT" + suffix);
            try (ResultSet resultSet = statement.executeQuery()) {
                while (resultSet.next()) {
                    String name = resultSet.getString("name");
                    int valueInt = resultSet.getInt("value_int");
                    if (name.startsWith("WIDTH")) {
                        width = valueInt;
                    } else if (name.startsWith("HEIGHT")) {
                        height = valueInt;
                    }
                }
            }
        } catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return new WidthHeight(width, height);
    }
}
