package ru.yandex;

import ru.yandex.models.RejectReasonDTO;

import java.util.List;

/**
 * @author freakbelka
 */
public class ModerationResult {

    private final List<RejectReasonDTO> reasons;
    private final boolean hasModerated;

    public ModerationResult(List<RejectReasonDTO> reasons, boolean hasModerated) {
        this.reasons = reasons;
        this.hasModerated = hasModerated;
    }

    public List<RejectReasonDTO> getReasons() {
        return reasons;
    }

    public boolean isApproved() {
        return !this.reasons.stream().anyMatch(s -> s.getIsPrevRejected() == 1);
    }

    public boolean isHasModerated() {
        return hasModerated;
    }
}
