package ru.yandex;

import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class PictureServlet extends HttpServlet {
    public final static String HEAD = "HEAD";

    private static final Logger logger = LoggerFactory.getLogger(PictureServlet.class);

    private static final String DOWNLOAD_FILE_QUERY = "select f.stillage_file_url, " +
            " dbo.fn_rus_to_eng(file_name) file_name, m.name " +
            " from dbo.vt_file f " +
            " join dbo.vt_file_instance fi on fi.file_nmb = f.nmb " +
            " join dbo.vc_mime_type m on mime_type_nmb = m.nmb " +
            " where f.nmb = ?";

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        doGet(request, response);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Connection localConnection = null;

        try {
            Context localContext = (Context) new InitialContext().lookup("java:comp/env");
            DataSource localDataSource = (DataSource) localContext.lookup("jdbc/moderation");
            localConnection = localDataSource.getConnection();

            final String fileNmb = request.getParameter("file_nmb");
            final String attach = request.getParameter("attach");

            String name = "com.digillect.servlet";

            final PreparedStatement preparedStatement = localConnection.prepareStatement(DOWNLOAD_FILE_QUERY);
            preparedStatement.setString(1, fileNmb);

            final ResultSet resultSet = preparedStatement.executeQuery();
            URL stillageFileUrl = null;
            String contentType = null;

            if (resultSet.next()) {
                name = resultSet.getString("file_name");
                stillageFileUrl = resultSet.getURL("stillage_file_url");
                contentType = resultSet.getString("name");
                if (contentType == null) {
                    contentType = "image/gif";
                }
            }
            contentType = contentType + ";file=\"" + name + "\"";

            response.setContentType(contentType);
            response.setHeader("Content-Type", contentType);
            response.setHeader("Content-Disposition", (attach != null ? "attachment;" : "") + "filename=\"" + name + "\"");

            if (!request.getMethod().equalsIgnoreCase(HEAD)) {
                try (InputStream fileStream = stillageFileUrl.openStream()) {
                    IOUtils.copy(fileStream, response.getOutputStream());
                }
            }

            preparedStatement.close();
        } catch (Exception e) {
            logger.error("Unexpected exception in picture servlet", e);
        } finally {
            if (localConnection != null) {
                try {
                    localConnection.close();
                } catch (Exception localException4) {
                }
            }
        }
    }
}
