package ru.yandex;

import org.apache.commons.lang3.StringUtils;

/**
 * @author elwood
 */
public final class PropertiesProvider {

    private static String getProperty(String key, String defaultValue) {
        final String value = System.getenv(key);
        return StringUtils.isNotBlank(value) ? value : defaultValue;
    }

    private static String getRequiredProperty(String key) {
        final String property = System.getenv(key);
        if (property == null)
            throw new RuntimeException(String.format("Required property '%s' not found", key));
        return property;
    }

    public static String getJdbcDriverClassName() {
        return getProperty("JDBC_DRIVERCLASSNAME", "net.sourceforge.jtds.jdbc.Driver");
    }

    public static String getJdbcUrl() {
        return getRequiredProperty("JDBC_URL");
    }

    public static String getJdbcUsername() {
        return getRequiredProperty("JDBC_USERNAME");
    }

    public static String getJdbcPassword() {
        return getRequiredProperty("JDBC_PASSWORD");
    }

    public static String getHttpPort() {
        return getProperty("HTTP_PORT", "8080");
    }

    public static String getWebappPath() {
        return getProperty("WEBAPP_PATH", "/usr/lib/yandex/bannerstorage-premoderation/webapp");
    }

    public static String getSheme() {
        return getProperty("HTTP_SCHEME", "http");
    }
}
