package ru.yandex.bannerstorage.premoderation.integration.stillage;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;


/**
 * @author skirsanov
 */
public class StillageClient {

    private static final Logger logger = LoggerFactory.getLogger(StillageClient.class);

    private static final String UPLOAD_FILES_PATH = "/api/v1/files/content/bin";

    private final String stillageUrl;
    private final RestTemplate restTemplate;


    public StillageClient(@Value("${STILLAGE_URL:https://bannerstorage-stillage.yandex.net}") final String stillageUrl) {
        this.stillageUrl = Objects.requireNonNull(stillageUrl);
        this.restTemplate = new RestTemplate();
    }

    /**
     * Uploads file to Stillage
     *
     * @param fileName some name for a file
     * @param body     data of the file
     * @return public URL to access that file
     * @throws URISyntaxException if stillageUrl is malformed
     */
    public StillageAnswer uploadFile(final String fileName, final byte[] body) {
        final URI requestUri = UriComponentsBuilder.fromHttpUrl(stillageUrl)
                .path(UPLOAD_FILES_PATH)
                .queryParam("fileName", fileName)
                .build()
                .toUri();

        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);

        logger.info("Executing request \"{}\"", requestUri);

        return restTemplate.postForObject(requestUri,
                new HttpEntity<>(body, headers),
                StillageAnswer.class);
    }
}
