package ru.yandex.bannerstorage.premoderation.model;

import java.util.Collection;
import java.util.Objects;

/**
 * mapping class for dbo.d_reason
 *
 * @author skirsanov
 */
public class Reason {
    private final String id;
    private final int nmb;
    private final String name;
    private final String ruen;
    private final String text;
    private final String reasonTypeId;
    private final String moderatorName;

    private ReasonType reasonType;
    private Collection<ReasonObjectLink> objectLinks;
    private Collection<Site> sites;
    private Collection<Geo> geos;

    public Reason(String id, int nmb, String name, String ruen, String text, String reasonTypeId,
                  String moderatorName) {
        this.id = id;
        this.nmb = nmb;
        this.name = name;
        this.ruen = ruen;
        this.text = text;
        this.reasonTypeId = reasonTypeId;
        this.moderatorName = moderatorName;
    }

    public void setReasonType(ReasonType reasonType) {
        this.reasonType = reasonType;
    }

    public void setSites(Collection<Site> sites) {
        this.sites = sites;
    }

    public void setGeos(Collection<Geo> geos) {
        this.geos = geos;
    }

    public String getId() {
        return id;
    }

    public int getNmb() {
        return nmb;
    }

    public String getName() {
        return name;
    }

    public String getRuen() {
        return ruen;
    }

    public String getText() {
        return text;
    }

    public String getReasonTypeId() {
        return reasonTypeId;
    }

    public String getModeratorName() {
        return moderatorName;
    }

    public String getReasonTypeName() {
        return reasonType != null ? reasonType.getName() : "";
    }

    public Collection<Site> getSites() {
        return sites;
    }

    public Collection<Geo> getGeos() {
        return geos;
    }

    public Collection<ReasonObjectLink> getObjectLinks() {
        return objectLinks;
    }

    public ReasonObjectLink getObjectLinkByObjectId(final String reasonObjectId) {
        Objects.requireNonNull(reasonObjectId);

        for (ReasonObjectLink link : objectLinks) {
            if (reasonObjectId.equalsIgnoreCase(link.getReasonObjectId())) {
                return link;
            }
        }
        return null;
    }

    public void setObjectLinks(Collection<ReasonObjectLink> objectLinks) {
        this.objectLinks = objectLinks;
    }
}
