package ru.yandex.controllers;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import ru.yandex.Utils;
import ru.yandex.utils.Language;

import javax.servlet.http.HttpServletRequest;
import javax.sql.DataSource;

import static ru.yandex.utils.Language.RUS;

/**
 * @author elwood
 */
@Controller
@RequestMapping("flash_test")
public class FlashTestController {
    private final DataSource dataSource;

    @Autowired
    public FlashTestController(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @RequestMapping("click_ok.jsp")
    public String clickOk(@RequestParam("link") String linkStr,
                          @RequestParam(value = "creative_version_nmb", required = false, defaultValue = "0") Integer creative_version_nmb,
                          @RequestParam(value = "originalValue", required = false) String originalValue,
                          HttpServletRequest request,
                          ModelMap modelMap) throws UnsupportedEncodingException, SQLException {
        Language lang = Language.fromRequest(request);
        String errorMessage = (lang == RUS)
                ? "<h1 style=\"color:red\">Клик НЕ ВЕРНЫЙ</h1>"
                : "<h1 style=\"color:red\">Wrong click</h1>";
        String msg;
        String a_href;
        String url_msg="";

        if (linkStr != null) {
            try {
                int link = Integer.parseInt(linkStr) - 1;
                if (creative_version_nmb != 0) {
                    try (Connection connection = dataSource.getConnection()) {
                        List<String> urls = Utils.getCreativeVersionURLs(connection, creative_version_nmb, false);
                        if (urls.size() > link) {
                            a_href = "<a href='" + urls.get(link) + "' target='_blank'>" + URLDecoder.decode(urls.get(link), "UTF-8") + "</a>";
                            url_msg = (lang == RUS)
                                    ? "<p>Отработать переход на сайт рекламодателя:</p>" + a_href
                                    : "<p>Follow advertiser's link:</p>" + a_href;
                        } else {
                            url_msg = (lang == RUS)
                                    ? "<p style='color: red; font-size: 20px;'>Рекламодатель забыл указать ссылку</p>"
                                    : "<p style='color: red; font-size: 20px;'>Advertiser forgot to set a link</p>";
                        }
                    }
                } else {
                    if (StringUtils.isNotBlank(originalValue)) {
                        a_href = "<a href='" + URLDecoder.decode(originalValue, "UTF-8") + "' target='_blank'>" + URLDecoder.decode(originalValue, "UTF-8") + "</a>";
                        url_msg = (lang == RUS)
                                ? "<p>Отработать переход на сайт рекламодателя:</p>" + a_href
                                : "<p>Follow advertiser's link:</p>" + a_href;
                    } else {
                        url_msg = (lang == RUS)
                                ? "<p style='color: red; font-size: 20px;'>Рекламодатель забыл указать ссылку</p>"
                                : "<p style='color: red; font-size: 20px;'>Advertiser forgot to set a link</p>";
                    }
                }
                if (link == 0) {
                    msg = (lang == RUS)
                            ? "Клик верный " + "(основной, <FONT SIZE=7>link1</FONT>)"
                            : "Correct click " + "(main, <FONT SIZE=7>link1</FONT>)";
                } else if (link > 0) {
                    msg = (lang == RUS)
                            ? "Клик верный " + "(" + link + " дополнительный, <FONT SIZE=7>link" + (link + 1) + "</FONT>)"
                            : "Correct click " + "(" + link + " additional, <FONT SIZE=7>link" + (link + 1) + "</FONT>)";
                } else {
                    msg = errorMessage;
                }
            } catch (NumberFormatException e) {
                msg = errorMessage;
            }
        } else {
            msg = errorMessage;
        }

        if (StringUtils.isNotBlank(url_msg)) {
            modelMap.put("url_msg", url_msg);
        }

        modelMap.put("msg", msg);
        modelMap.put("closeWindowMsg", (lang == RUS) ? "Закрыть окно" : "Close window");
        return "flash_test/click_ok";
    }
}
