package ru.yandex.controllers;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

import javax.servlet.http.HttpServletRequest;
import javax.sql.DataSource;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Hashtable;

/**
 * @author freakbelka
 */
@Controller
@RequestMapping("reason")
public class ReasonsController {
    private final DataSource dataSource;

    @Autowired
    public ReasonsController(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @RequestMapping("reason.jsp")
    public String reason() {
        return "reason/reason";
    }

    @RequestMapping("reasons.jsp")
    public String reasons() {
        return "reason/reasons";
    }

    private Hashtable getUser(HttpServletRequest request) {
        return (Hashtable<String, String>) request.getSession().getAttribute("user");
    }

    private boolean isAdmin(HttpServletRequest request) {
        return getUser(request).get("admin") != null;
    }

    @RequestMapping("change")
    public String changeReason(@RequestParam("id") String id,
                               @RequestParam(value = "name", required = false) String name,
                               @RequestParam(value = "text", required = false) String text,
                               @RequestParam(value = "moderator_name", required = false) String moderatorName,
                               @RequestParam(value = "RUEN", required = false) String ruen,
                               @RequestParam(value = "site_nmb", required = false) String siteNmb,
                               @RequestParam(value = "geo_nmb", required = false) String geoNmb,
                               @RequestParam(value = "object_nmb", required = false) String objectNmb,
                               HttpServletRequest request) throws SQLException {
        String redirect = "/reason/reason";
        if (isAdmin(request)) {
            if (siteNmb != null && !siteNmb.isEmpty()) siteNmb = siteNmb.substring(0, siteNmb.length() - 1);
            if (geoNmb != null && !geoNmb.isEmpty()) geoNmb = geoNmb.substring(0, geoNmb.length() - 1);
            if (objectNmb != null && !objectNmb.isEmpty()) objectNmb = objectNmb.substring(0, objectNmb.length() - 1);

            if (objectNmb == null || objectNmb.isEmpty()) {
                throw new IllegalStateException("Причина отклонения должна быть привязана хотя бы к одному объекту");
            } else {

                try (Connection connection = dataSource.getConnection()) {
                    try (PreparedStatement stmt = connection.prepareStatement(
                            "exec sp_moderation_creative_reason 'change' , @id = ?, @moderator_name = ?, @name = ?, @text = ?, @site_nmb = ?, @geo_nmb = ?, @object_nmb = ?, @RUEN = ?")) {
                        stmt.setString(1, id);
                        stmt.setString(2, moderatorName);
                        stmt.setString(3, name);
                        stmt.setString(4, text);
                        stmt.setString(5, siteNmb);
                        stmt.setString(6, geoNmb);
                        stmt.setString(7, objectNmb);
                        stmt.setString(8, ruen);
                        stmt.executeUpdate();
                    }
                }

                redirect = "/reason/reason.jsp?id=" + id;
            }
        }
        return redirect;
    }

    @RequestMapping("create")
    public String createReason(@RequestParam("name") String name,
                               @RequestParam("reason_object_id") String reasonObjectId,
                               @RequestParam("reason_type_id") String reasonTypeId,
                               HttpServletRequest request) throws SQLException {
        String redirect = "/reason/reason";
        if (isAdmin(request)) {
            if (!name.isEmpty() && !reasonObjectId.isEmpty() && !reasonTypeId.isEmpty()) {
                try (Connection connection = dataSource.getConnection()) {
                    try (PreparedStatement stmt = connection.prepareStatement(
                            "exec sp_moderation_creative_reason 'create' , @name = ?, @reason_object_id = ?, @reason_type_id = ?, @RUEN = ?")) {
                        stmt.setString(1, name);
                        stmt.setString(2, reasonObjectId);
                        stmt.setString(3, reasonTypeId);
                        stmt.setString(4, getUser(request).get("RUEN").toString());
                        try (ResultSet rs = stmt.executeQuery()) {
                            if (rs.next()) redirect = "/reason/reason.jsp?id=" + rs.getString("id");
                        }
                    }
                }
            } else {
                throw new IllegalStateException("Для создания причины отклонения должны быть указаны имя, объект и тип");
            }
        }
        return redirect;
    }


    @RequestMapping("delete")
    public String deleteReason(@RequestParam("id") String id,
                               HttpServletRequest request) throws SQLException {
        if (isAdmin(request)) {
            try (Connection connection = dataSource.getConnection()) {
                try (PreparedStatement stmt = connection.prepareStatement(
                        "exec sp_moderation_creative_reason 'delete' , @id = ?")) {
                    stmt.setString(1, id);
                    stmt.executeUpdate();
                }
            }
        }
        return "reason/reasons";
    }

    @RequestMapping("sort")
    public String sortReason(@RequestParam("id") String id,
                             @RequestParam("sort") String sort,
                             @RequestParam("reason_object_link_nmb") String reasonObjectLinkNmb,
                             HttpServletRequest request
    ) throws SQLException {
        if (isAdmin(request)) {
            try (Connection connection = dataSource.getConnection()) {
                try (PreparedStatement stmt = connection.prepareStatement(
                        "exec sp_moderation_creative_reason 'sort' , @id = ?, @sort = ?, @reason_object_link_nmb = ?")) {
                    stmt.setString(1, id);
                    stmt.setString(2, sort);
                    stmt.setString(3, reasonObjectLinkNmb);
                    stmt.executeUpdate();
                }
            }
        }
        return "reason/reasons";
    }

    @RequestMapping("deleteType")
    public String deleteType(@RequestParam("id") String id,
                             HttpServletRequest request) throws SQLException {
        if (isAdmin(request)) {
            try (Connection connection = dataSource.getConnection()) {
                try (PreparedStatement stmt = connection.prepareStatement(
                        "exec sp_moderation_creative_reason 'delete_type' , @id = ?")) {
                    stmt.setString(1, id);
                    stmt.executeUpdate();
                }
            }
        }
        return "reason/reasons";
    }

    @RequestMapping("createType")
    public String createType(@RequestParam("name") String name,
                             HttpServletRequest request) throws SQLException {
        if (isAdmin(request)) {
            try (Connection connection = dataSource.getConnection()) {
                try (PreparedStatement stmt = connection.prepareStatement(
                        "exec sp_moderation_creative_reason 'create_type' , @name = ?")) {
                    stmt.setString(1, name);
                    stmt.executeUpdate();
                }
            }
        }
        return "reason/reasons";
    }

}
