package ru.yandex.services;

import ru.yandex.models.SiteDTO;

import javax.sql.DataSource;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

/**
 * @author freakbelka
 */
public class CreativeService {
    private final DataSource dataSource;

    public CreativeService(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    private List<SiteDTO> loadSites(int creativeVersionNmb, String sqlStmt) throws SQLException {
        List<SiteDTO> sites = new ArrayList<>();
        try (Connection connection = dataSource.getConnection()) {
            try (PreparedStatement stmt = connection.prepareStatement(
                    sqlStmt)) {
                stmt.setInt(1, creativeVersionNmb);
                try (ResultSet rs = stmt.executeQuery()) {
                    while (rs.next()) {
                        sites.add(new SiteDTO(rs.getString("name"), rs.getInt("exclude"), rs.getInt("red_color")));
                    }
                }
            }
        }
        return sites;
    }

    public List<SiteDTO> getAllSites(int creativeVersionNmb) throws SQLException {
        return getSites(creativeVersionNmb, false);
    }

    private List<SiteDTO> getSites(int creativeVersionNmb, boolean onlyRed) throws SQLException {
        String sqlStmt = "select name, exclude, red_color\n" +
                         "from dbo.uf_get_creative_version_sites(?)\n" +
                         "join vd_site on nmb = site_nmb\n" +
                         "%s\n" +
                         "order by name";
        String sql = String.format(sqlStmt, onlyRed ? "where red_color = 1" : "");
        return loadSites(creativeVersionNmb, sql);
    }

    public List<SiteDTO> getRedSites(int creativeVersionNmb) throws SQLException {
        return getSites(creativeVersionNmb, true);
    }

    public int getRedPixel(int creativeVersionNmb) throws SQLException {
        int redPixel = 0;
        try (Connection connection = dataSource.getConnection()) {
            try (PreparedStatement stmt = connection.prepareStatement(
                    "select" +
                    "   case when count(*) > 0 then 1 else 0 end red_pixel" +
                    " from dbo.uf_get_creative_version_sites(?) cs" +
                    " join vd_site s on s.nmb = site_nmb" +
                    " where s.name like '%главная%'" +
                    " and s.is_secure = 0")) {
                stmt.setInt(1, creativeVersionNmb);
                try (ResultSet rs = stmt.executeQuery()) {
                    while (rs.next()) {
                        redPixel = redPixel + rs.getInt("red_pixel");
                    }
                }
            }
        }
        return redPixel;
    }
}
