package ru.yandex.utils;

/**
 * @author skirsanov
 */
public class Environment {

    private static Environment environment = new Environment();

    private Environment() {
    }

    public static Type getType() {
        return environment.type;
    }

    public static boolean isDevelopmentOrTesting() {
        return environment.type == Type.TESTING || environment.type == Type.DEVELOPMENT;
    }

    public static boolean isProduction() {
        return environment.type == Type.PRODUCTION;
    }

    protected Type type = Type.fromString(System.getProperty("environment", "production"));

    public enum Type {
        DEVELOPMENT,
        TESTING,
        PRODUCTION;

        public static Type fromString(final String type) {
            if (type == null) {
                return PRODUCTION;
            }

            for (Type t : Type.values()) {
                if (t.toString().toLowerCase().equals(type.toLowerCase())) {
                    return t;
                }
            }

            return PRODUCTION;
        }
    }
}
