package ru.yandex.utils;


import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.net.ssl.*;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;

/**
 * Утилитный класс для работы с SSL.
 * @author {@literal Alexey Balchunas <bleshik@yandex-team.ru>}
 * @since 2.13
 */
public final class SslUtils {
    private SslUtils() {}
    private static final Logger log = LoggerFactory.getLogger(SslUtils.class);

    /**
     * Делает, чтобы по умолчанию принимались все сертификаты при установлении SSL сессии.
     * *************************************
     * * НЕ ИСПОЛЬЗОВАТЬ В PRODUCTION'Е!!! *
     * *************************************
     */
    public static void disableSslCheck() {
        HttpsURLConnection.setDefaultSSLSocketFactory(buildInsecureSSLContext().getSocketFactory());
        HttpsURLConnection.setDefaultHostnameVerifier(buildInsecureHostnameVerifier());
    }

    /**
     * Creates all-trusting host name verifier
     */
    public static HostnameVerifier buildInsecureHostnameVerifier() {
        return (hostname, session) -> true;
    }

    /**
     * Creates SSLContext that relies on trust manager that does not validate certificate chains
     */
    public static SSLContext buildInsecureSSLContext() {
        TrustManager[] trustAllCerts = new TrustManager[] {new X509TrustManager() {
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }
                public void checkClientTrusted(X509Certificate[] certs, String authType) {}
                public void checkServerTrusted(X509Certificate[] certs, String authType) {}
            }
        };

        try {
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new java.security.SecureRandom());
            return sc;
        } catch (KeyManagementException | NoSuchAlgorithmException e) {
            log.error("SslUtils", e);
            throw new RuntimeException(e);
        }
    }
}
