#!/bin/bash
MODULE=bannerstorage-premoderation
WORKING_DIRECTORY=/
DEBUG_PORT=38100
ENVIRONMENT="production"
JAVA_HOME=/usr/local/java8

if [ -f /etc/yandex/environment.type ] ; then
    ENVIRONMENT=`cat /etc/yandex/environment.type`
fi

if [ ! -d $WORKING_DIRECTORY/var/log/$MODULE ] ; then
    mkdir -p $WORKING_DIRECTORY/var/log/$MODULE
fi

if [ ! -d $WORKING_DIRECTORY/var/run/$MODULE ] ; then
    mkdir -p $WORKING_DIRECTORY/var/run/$MODULE
fi

LIB=$WORKING_DIRECTORY/usr/lib/yandex/$MODULE/libs
log_rc=$WORKING_DIRECTORY/var/log/$MODULE/$MODULE.log.shell
sql_log_file=$WORKING_DIRECTORY/var/log/$MODULE/$MODULE.sql.log
log_errors_file=$WORKING_DIRECTORY/var/log/$MODULE/$MODULE-errors.log
log_gc=$WORKING_DIRECTORY/var/log/$MODULE/$MODULE.gc.log

PATH="$JAVA_HOME/bin:$PATH"
LANG=en_US.UTF-8

CLASSPATH=`find $LIB -maxdepth 3 \( -name '*.jar' \) -exec printf {}: \;`$WORKING_DIRECTORY/etc/yandex/$MODULE:$WORKING_DIRECTORY/etc/datasources:$CLASSPATH

export PATH LANG JAVA_HOME CLASSPATH


echo 'Applying verba!'
/usr/bin/bannerstorage-premoderation-verba-apply.py

echo 'Starting service!'
java $JAVA_OPTIONS \
     -classpath $CLASSPATH \
     -Xloggc:$log_gc -XX:+PrintGCDetails -XX:+PrintGCTimeStamps \
     -XX:+HeapDumpOnOutOfMemoryError \
     -XX:-OmitStackTraceInFastThrow \
     -Dnetworkaddress.cache.ttl=30 \
     -Dfile.encoding=UTF-8 \
     -Djava.awt.headless=true \
     -Denvironment=$ENVIRONMENT \
     -Dmodule.name=$MODULE \
     -Dsql.log.file=$sql_log_file \
     -Dlog.errors.file=$log_errors_file \
     -agentlib:jdwp=transport=dt_socket,server=y,suspend=n,address=$DEBUG_PORT \
     -showversion -server -Xverify:none \
     -Xmx2048m -Xms256m -XX:+UseParallelGC \
     -Dhost.name=`/bin/hostname` \
     -Dsun.net.client.defaultConnectTimeout=10000 \
     -Dsun.net.client.defaultReadTimeout=10000 \
     -Dsun.net.inetaddr.ttl=60 \
     -Dhttp.keepAlive=false \
      ru.yandex.Application
if [ $? -ne 0 ]; then
    exit 1
fi
echo $! > $WORKING_DIRECTORY/var/run/$MODULE/$MODULE.pid
