﻿<%@ page contentType="text/html; charset=utf-8"%>
<%@ include file="../include/top_ssi.jsp" %>
<%@ include file="../include/functions/functions.jsp" %>
<html>
<head>
        <%
 response.setHeader("Pragma","no-cache");
 response.setHeader("Expires","0");
 response.setDateHeader("Expires", 0);

 /*
 Страница разработана чтобы показывать в премодерации превью креативов для мобильного расхлопа, код которых в формате JSON.
 Мобильная морда вызывает авапс серверным вызовом, в котором получает json.
 Код используемый для показа взят с морды(Я).
 https://st.yandex-team.ru/BANNERSTORAGE-4563
  */

%>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0">
<meta http-equiv="X-UA-Compatible" content="ie=edge">
<title>Document</title>
<body >
<style>
    html, body {
        height: 100%;
        margin: 0;
    }

    .banner__wrapper {
        position: relative;
        z-index: 11;
    }

    .body_covers_yes .banner__wrapper {
        visibility: hidden
    }

    .banner__link-outer {
        max-height: 82px;
        overflow: hidden;
        -webkit-transition: -webkit-transform 0.4s ease-out;
        transition: transform 0.4s ease-out;
        -webkit-transform-origin: 0 0;
        transform-origin: 0 0;
    }

    .banner_opened_yes:not(.banner_tablet_yes) .banner__link-outer {
        -webkit-transform: scaleY(4);
        transform: scaleY(4);
    }

    .banner__link {
        position: relative;
        padding-bottom: 20.9375%;
        display: block;
        left: 0;
        top: 0;
        width: 100%;
        -webkit-tap-highlight-color: rgba(0, 0, 0, 0);
    }

    .banner__frame0 {
        position: absolute;
        width: 100%;
        height: 100%;
        max-height: 82px;
        z-index: -1;
    }

    .banner__inner {
        position: absolute;
        width: 100%;
        height: 400%;
        top: 0;
        overflow: hidden;
        -webkit-transition: 0.4s ease-out;
        transition: 0.4s ease-out;
        -webkit-transition-property: -webkit-transform, opacity;
        transition-property: transform, opacity;
        -webkit-transform-origin: 0 0;
        transform-origin: 0 0;
        -webkit-transform: scaleY(0.25);
        transform: scaleY(0.25);
        opacity: 0;
        visibility: hidden;
    }

    .banner_opened_yes:not(.banner_tablet_yes) .banner__inner {
        -webkit-transform: none;
        transform: none;
        opacity: 1;
        visibility: visible;
    }

    .banner__frame1 {
        display: none;
        position: absolute;
        width: 100%;
        height: 100%;
    }

    .banner_loaded_yes .banner__frame1 {
        display: block;
    }

    .banner__loader {
        position: absolute;
        left: 50%;
        top: 50%;
        margin-left: -12px;
        margin-top: -12px;
    }

    .banner_loaded_yes .banner__loader {
        display: none;
    }

    .banner__close {
        position: absolute;
        top: 0;
        left: 0;
        z-index: 11;
        width: 100%;
        height: 100%;
        background: rgba(0, 0, 0, 0.7);
        cursor: pointer;
        -webkit-user-select: none;
        -ms-user-select: none;
        user-select: none;
        opacity: 0;
        visibility: hidden;
    }

    .banner__close-icon {
        position: fixed;
        bottom: 35px;
        left: 50%;
        width: 46px;
        height: 46px;
        margin-left: -23px;
    }

    .banner_opened_yes:not(.banner_tablet_yes) .banner__close {
        opacity: 1;
        visibility: visible;
    }

    .loader {
        display: inline-block;
        width: 24px;
        height: 24px;
        background-repeat: no-repeat;
        background-image: url("data:image/svg+xml;charset=utf8,%3Csvg xmlns='http://www.w3.org/2000/svg' width='24' height='24' viewBox='0 0 24 24'%3E%3Cpath d='M24 12.182C24 18.71 18.628 24 12 24S0 18.71 0 12.182h1.477c0 5.723 4.71 10.362 10.523 10.362 5.812 0 10.523-4.64 10.523-10.362H24z' fill='%23fc0' fill-rule='evenodd'/%3E%3C/svg%3E");
        -webkit-animation: rotation 1s linear normal infinite;
        animation: rotation 1s linear normal infinite;
    }
    .no-data-url .loader {
        background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABgAAAAYCAYAAADgdz34AAABIklEQVR4Ae1TBU4FMBRr4AI4xHG9FO4aw50D4HAF3N3d9Qq4E8Fhow93/f+jTeZb+1634R//+Mc/vgPOJjCrJhAKA4OckcKNs3FssOQZPPBJlJB3TQQGOOgxgjPDLH2ilEORIz0PS4PZMw1b8p5SIBNqDD56EpqexcFAIF8Ci2bxvParmVmsSxYGiX4c24y+/nZyCl5iE4UqtIYZPgg5S54GlkM64/7wWYVJWhTJ/4iILoc5z5YKh5pE0HM3n3klUsfW5s22jMCeZ5quyNNe+yAB3HwgPnJzkpqF3bNRj8GB+1NIvMsz+7Ta762/0IUHKq+yOaXYqHwcCqZLEStYxjh/xqK4r1yPwxnvhRwiYSLJ2mnfojwEKVf9NnmOahROeAHnBw/RZ/c6CV8AAAAASUVORK5CYII=");
    }
    @-webkit-keyframes rotation {
        to {
            -webkit-transform: rotate(360deg);
            transform: rotate(360deg);
        }
    }
    @keyframes rotation {
        to {
            -webkit-transform: rotate(360deg);
            transform: rotate(360deg);
        }
    }

</style>
<script src="https://home.yastatic.net/jquery/2.1.4/jquery.js"></script>
<script>
    var code = ${code};
    var data = code.mobile_expandable_banner;
    var small_iframe = data.small_iframe_src;
    var big_iframe = data.big_iframe_src;

    var getTouchEvents = function (event) {
        var originalEvent = event.originalEvent;
        return (originalEvent.touches && originalEvent.touches.length) ? originalEvent.touches : originalEvent.changedTouches;
    };

    var getTouchEvent = function (e) {
        var eventsList = getTouchEvents(e),
                event,
                x,
                y;
        if (eventsList && eventsList.length) {
            event = eventsList[0];
        } else {
            event = e.originalEvent;
        }

        x = event.pageX || event.clientX;
        y = event.pageY || event.clientY;

        return {
            x: x,
            y: y
        };

    };

    if (data) {
        $('body').append(
                '<div class="banner">' +
                '<div class="banner__close" role="button" tabindex="0" title="Закрыть">' +
                '<svg xmlns="http://www.w3.org/2000/svg" class="banner__close-icon" viewBox="0 0 46 46"><circle cx="23" cy="23" r="22" fill="#fff"></circle><path d="M15 31l16-16M15 15l16 16" fill="none" stroke="#000" stroke-width="2"></path></svg>' +
                '</div>' +
                '<div class="banner__wrapper">' +
                '<div class="banner__link-outer">' +
                '<a href="' + data.click_url + '" class="banner__link" target="_blank">' +
                '<iframe src="' + small_iframe + '" class="banner__frame0" frameborder="0" sandbox="allow-popups allow-popups-to-escape-sandbox allow-scripts allow-same-origin allow-top-navigation allow-forms"></iframe>' +
                '</a>' +
                '</div>' +
                '<div class="banner__inner" style="background: ' + data.bgcolor + '">' +
                '<iframe data-src="' + big_iframe + '&amp;origin=' + location.protocol + '//' + location.host + '" class="banner__frame1" frameborder="0" sandbox="allow-popups allow-popups-to-escape-sandbox allow-scripts allow-same-origin allow-top-navigation allow-forms"></iframe>' +
                '<div class="banner__loader loader"></div>' +
                '</div>' +
                '</div>' +
                '</div>'
        );

        var $banner = $('.' + 'banner');
        var $inner = $('.' + 'banner__link-outer');

        var start;
        var opened = false;

        var toggle = function (toggle) {
            if (opened === toggle) {
                return;
            }

            opened = toggle;
            $banner.toggleClass('banner_opened_yes', opened);

            var $frame = $('.' + 'banner__frame1');
            if (!opened) {
                $frame.removeAttr('src');
                $banner.removeClass('banner_loaded_yes');
            } else {
                if (!$frame.attr('src')) {
                    var defs = [$.Deferred(), $.Deferred()];
                    $frame.on('load', function () {
                        defs[0].resolve();
                    }).attr('src', $frame.data('src'));
                    setTimeout(function () {
                        defs[1].resolve();
                    }, 400);
                    // После окончания загрузки и анимации (примерно 400 мс) показываем баннер
                    // Загрузку ждём, чтобы не показывать разбитый баннер
                    // Анимацию ждём, чтобы её не ломать в процессе
                    $.when(defs[0], defs[1]).then(function () {
                        $banner.addClass('banner_loaded_yes');
                    });
                }
            }

            start = null;
        };

        $inner.on('touchstart', function (event) {
            start = getTouchEvent(event);

            if ($(event.target).hasClass('banner__inner')) {
                return false;
            }
        });

        $inner.on('touchmove', function (event) {
            if (!start) {
                return;
            }

            var y = getTouchEvent(event).y;

            if (!opened) {
                if (y - start.y > 10) {
                    toggle(true);
                }
            } else {
                if (y < start.y) {
                    toggle(false);
                }
            }

            return false;
        });

        $inner.on('touchend touchcancel', function (event) {
            if (start && Math.abs(getTouchEvent(event).y - start.y) < 10) {
                toggle(!opened);

                return false;
            }

            start = null;
        });

        $inner.on('click', function () {
            toggle(!opened);

            return false;
        });

        $('.' + 'banner__close').on('click', function () {
            toggle(false);
            return false;
        });

        $(window).on('message', function (event) {
            event = event.originalEvent;

            if ($('.' + 'banner__frame1')[0].contentWindow !== event.source) {
                return;
            }

            var msg;
            try {
                msg = JSON.parse(event.data);
            } catch (err) {
                return;
            }

            // Команда закрытия баннера
            if (msg && msg.command && msg.command === 'close') {
                toggle(false);
            }
        });
    }
</script>
</div>
</body>
</html>
<%@ include file="../include/bottom_ssi.jsp" %>