<%!

  public class NumberFormat
  {
    protected int days = 0;
    protected int hours = 0;
    protected int minutes = 0;
    protected int minutes_sum;

    protected String days_word = "";
    protected String hours_word = "";
    protected String minutes_word = "";

    public NumberFormat(int minutes_sum)
    {
      this.minutes_sum = minutes_sum;
      days = minutes_sum / 1440;
      hours = (minutes_sum - 1440 * days) / 60;
      minutes = (minutes_sum - 1440 * days) - 60 * hours;
 
      days_word = word_form(days, "дней", "день", "дня");
      hours_word = word_form(hours, "часов", "час", "часа");
      minutes_word = word_form(minutes, "минут", "минута", "минуты");
    }

    public NumberFormat(int days, int hours, int minutes)
    {
      minutes_sum = days * 1440 + hours * 60 + minutes;
      this.days = minutes_sum / 1440;
      this.hours = (minutes_sum - 1440 * this.days) / 60;
      this.minutes = (minutes_sum - 1440 * this.days) - 60 * this.hours;

      days_word = word_form(this.days, "дней", "день", "дня");
      hours_word = word_form(this.hours, "часов", "час", "часа");
      minutes_word = word_form(this.minutes, "минут", "минута", "минуты");
    }

    public int getDays() { return days; }
    public int getHours() { return hours; }
    public int getMinutes() { return minutes; }
    public int getMinutesSum() { return minutes_sum; }
    public String getDaysWord() { return days_word; }
    public String getHoursWord() { return hours_word; }
    public String getMinutesWord() { return minutes_word; }


    public String toString()
    {
       String res = "";
       if(minutes > 0) res = minutes + " " + minutes_word;
       if(hours > 0) res = hours + " " + hours_word + " " + res;
       if(days > 0) res = days + " " + days_word + " " + res;
       if(res.length() == 0) res = "минут";
       return res;
    }

    public String word_form(int num, String form1, String form2, String form3)
    {
      int last = num - num / 10 * 10;
      int prev_last = (num / 10) - num / 100 * 10;
      if(prev_last == 1 || last == 0 || (last >= 5 && last <= 9)) return form1;
      if(last == 1) return form2;
      return form3;
    } 

  }

%>