﻿<%@ page import="com.google.common.collect.Lists" %>
<%@ page import="com.google.common.primitives.Ints" %>
<%@ page import="ru.yandex.bannerstorage.premoderation.model.*" %>
<%@ page import="java.util.stream.Collectors" %>
<%@ page import="static com.google.common.base.Strings.isNullOrEmpty" %>
<%@ page contentType="text/html; charset=utf-8"%>
<%@ include file="../include/top_ssi.jsp" %>
<%@ include file="../include/admin_top_utf.jsp" %>
<%@ include file="../include/functions/functions.jsp" %>

<%!
  //TODO::duplicate QUERY in reason.jsp
  private static final String SELECT_ALL_OBJECTS = "select * from dbo.vc_reason_object where archive = 0 order by name";
  private static final String SELECT_ALL_REASON_TYPES = "select * from dbo.vd_reason_type where archive = 0 order by name";

  private static final String SELECT_GEO_BY_REASONS = "SELECT " +
          "  rg.reason_id, " +
          "  g.name, " +
          "  g.yandex_nmb " +
          "FROM sqllogc.geobaza_v1.dbo.vt_geo g " +
          "JOIN dbo.r_reason_geo rg ON rg.archive = 0 AND rg.geo_nmb = g.yandex_nmb " +
          "WHERE g.type = 3";

  private static final String SELECT_SITE_BY_REASONS = "SELECT " +
          "  rs.reason_id, s.name, s.nmb " +
          "FROM dbo.vr_reason_site rs " +
          "  JOIN dbo.vd_site s ON rs.site_nmb = s.nmb " +
          "WHERE rs.archive = 0";

  private static final String SELECT_OBJECT_BY_REASONS = "SELECT " +
          "ro.nmb, ro.reason_nmb, ro.sort, ro.object_nmb " +
          "FROM dbo.r_reason_object ro " +
          "WHERE ro.archive = 0";
%>

<%
  String reason_object_id = request.getParameter ("reason_object_id");
  String reason_type_id = request.getParameter ("reason_type_id");
  if (reason_object_id == null) {
    reason_object_id = "";
  }
  final String reasonObjectId = reason_object_id;

  /* Флаг о том, включена ли фильтр по объектам. Нужно для сортировки списка и отображения редактирования
   * сортировки в списке */
  final boolean objectFilterEnabled = !isNullOrEmpty(reasonObjectId);

  if(reason_type_id == null) reason_type_id = "";

  Statement stmt = db.createStatement(); 
  String req;
  ResultSet rs;

  final List<ReasonObject> reasonObjects = new ArrayList<>();
  final Map<Integer, ReasonObject> objectsByNmb = new HashMap<>();
  rs = stmt.executeQuery(SELECT_ALL_OBJECTS);
  while (rs.next()) {
    final ReasonObject reasonObject = new ReasonObject(rs.getString("id"), rs.getInt("nmb"), rs.getString("name"));
    reasonObjects.add(reasonObject);
    objectsByNmb.put(reasonObject.getNmb(), reasonObject);
  }

  rs = stmt.executeQuery(SELECT_ALL_REASON_TYPES);
  final List<ReasonType> types = new ArrayList<>();
  final Map<String, ReasonType> typesById = new HashMap<>();
  while (rs.next()) {
    final ReasonType reasonType = new ReasonType(rs.getString("id"), rs.getInt("nmb"), rs.getString("name"));
    types.add(reasonType);
    typesById.put(reasonType.getId(), reasonType);
  }


//Geo
    rs = stmt.executeQuery(SELECT_GEO_BY_REASONS);

    final Map<String, Collection<Geo>> geoByReasons = new HashMap<>();
    while (rs.next()) {
      final String reasonId = rs.getString("reason_id");

      //use Map.putIfAbsent
      if (!geoByReasons.containsKey(reasonId)) {
        geoByReasons.put(reasonId, new ArrayList<>());
      }
      geoByReasons.get(reasonId).add(new Geo(rs.getInt("yandex_nmb"), rs.getString("name")));
    }


//Sites
    final Map<String, Collection<Site>> siteByReasons = new HashMap<>();
    rs = stmt.executeQuery(SELECT_SITE_BY_REASONS);
    while (rs.next()) {
      final String reasonId = rs.getString("reason_id");
      if (!siteByReasons.containsKey(reasonId)) {
        siteByReasons.put(reasonId, new ArrayList<>());
      }
      siteByReasons.get(reasonId).add(new Site(rs.getInt("nmb"), rs.getString("name")));
    }


//Objects
  final Map<Integer, List<ReasonObjectLink>> objectsByReasons = new HashMap<>();
  rs = stmt.executeQuery(SELECT_OBJECT_BY_REASONS);
  while (rs.next()) {
    final int nmb = rs.getInt("nmb");
    final int reasonNmb = rs.getInt("reason_nmb");
    final int sort = rs.getInt("sort");
    final int objectNmb = rs.getInt("object_nmb");
    if (!objectsByReasons.containsKey(reasonNmb)) {
      objectsByReasons.put(reasonNmb, new ArrayList<>());
    }

    objectsByReasons.get(reasonNmb).add(new ReasonObjectLink(nmb, reasonNmb, sort, objectNmb, objectsByNmb.get(objectNmb)));
  }


//Reasons
  final List<Reason> reasons = new ArrayList<>();
  req = "sp_moderation_creative_reason 'select_all'";
  if (reason_object_id.length() > 10) req = req + ", @reason_object_id = '" + reason_object_id + "'";
  if(reason_type_id.length() > 10) req = req + ", @reason_type_id = '" + reason_type_id + "'";
  rs = stmt.executeQuery(req);
  while(rs.next()) {
    final String reasonId = rs.getString("id");
    final int reasonNmb = rs.getInt("nmb");
    final Reason reason = new Reason(reasonId, reasonNmb, rs.getString("name"),
            rs.getString("RUEN"), rs.getString("text"), rs.getString("reason_type_id"), rs.getString("moderator_name"));

    reason.setReasonType(typesById.get(reason.getReasonTypeId()));
    reason.setGeos(geoByReasons.get(reasonId));
    reason.setSites(siteByReasons.get(reasonId));
    final List<ReasonObjectLink> reasonObjectLinks = objectsByReasons.getOrDefault(reasonNmb, Collections.emptyList());

    reasonObjectLinks.sort(Comparator.comparing(ReasonObjectLink::getReasonObjectName));
    reason.setObjectLinks(reasonObjectLinks);

    reasons.add(reason);
  }

    final Comparator<Reason> reasonComparator;
    if (objectFilterEnabled) {
        reasonComparator = Comparator.comparing(Reason::getReasonTypeName)
                .thenComparingInt(r -> r.getObjectLinkByObjectId(reasonObjectId).getSort());
    } else {
        reasonComparator = Comparator.comparing(Reason::getReasonTypeName)
                .thenComparing(r -> r.getObjectLinks().stream()
                        .map(ReasonObjectLink::getReasonObjectName).collect(Collectors.joining(",")))
                .thenComparing(Comparator.comparing(r -> r.getObjectLinks().stream()
                                .mapToInt(ReasonObjectLink::getSort).toArray(),
                        Ints.lexicographicalComparator()));
    }

    reasons.sort(reasonComparator);

  int n = 0;
%>
<div class="container-fluid">
  <h3><%= RUEN.equals("RU") ? "Причины отклонения" : "Reject reasons"%>
  </h3>
  <br>
  <div class="row">
    <div class="col">
      <form action="reasons.jsp">

        <div class="form-group row">
          <label for="reasonObjectSelect"
                 class="col-sm-2 col-sm-auto col-form-label col-form-label-sm"><%= RUEN.equals("RU") ? "Объект" : "Object"%>
          </label>
          <div class="col-sm-5 col-sm-auto ">
            <select name="reason_object_id" class="form-control form-control-sm" id="reasonObjectSelect">
              <option value="">Все</option>
              <%
                for (ReasonObject reason : reasonObjects) {
              %>
              <option value="<%= reason.getId()%>" <%= reason_object_id.equalsIgnoreCase(reason.getId()) ? "selected" : ""%>><%= reason.getName()%>
              </option>
              <%
                }
              %>
            </select>
          </div>
        </div>
        <div class="form-group row">
          <label for="reasonTypeSelect"
                 class="col-sm-2 col-sm-auto col-form-label col-form-label-sm"><%= RUEN.equals("RU") ? "Тип" : "Type"%>
          </label>
          <div class="col-sm-5 col-sm-auto ">
            <select name="reason_type_id" class="form-control form-control-sm" id="reasonTypeSelect">
              <option value="">Все</option>
              <%
                for (ReasonType type : types) {
              %>
              <option value="<%= type.getId()%>"<%= reason_type_id.equals(type.getId()) ? "selected" : ""%>><%= type.getName()%>
              </option>
              <%
                }
              %>
            </select>
          </div>
        </div>
        <div class="form-group row">
          <div class="offset-sm-2 col-sm-5">
            <button type="submit" class="btn btn-outline-primary btn-sm"><%= RUEN.equals("RU") ? "Фильтр" : "Filter"%>
            </button>
          </div>
        </div>
      </form>
    </div>
    <div class="col-1">
    </div>
    <div class="col">
      <form name="f1" action="/reason/create" method="post">
        <div class="form-group row">
        <label for="nameInput"
               class="col-sm-3 col-form-label col-form-label-sm"><%= RUEN.equals("RU") ? "Новая причина" : "New reason"%>
        </label>
          <div class="col-sm-5">
        <input class="form-control form-control-sm" type="text" name="name" id="nameInput" value="">
        </div>
        </div>
        <div class="form-group row">
          <label for="reasonObjectSelect2"
                 class="col-sm-2 col-form-label col-form-label-sm"><%= RUEN.equals("RU") ? "Объект" : "Object"%>
          </label>
          <div class="col-sm-6">
            <select name="reason_object_id" class="form-control form-control-sm" id="reasonObjectSelect2">
              <option value="">Все</option>
              <%
                for (ReasonObject reason : reasonObjects) {
              %>
              <option value="<%= reason.getId()%>"> <%= reason.getName()%> </option>
              <%
                }
              %>
            </select>
          </div>
        </div>
        <div class="form-group row">
          <label for="reasonTypeSelect2"
                 class="col-sm-2 col-form-label col-form-label-sm"><%= RUEN.equals("RU") ? "Тип" : "Type"%>
          </label>
          <div class="col-sm-6">
            <select name="reason_type_id" class="form-control form-control-sm" id="reasonTypeSelect2">
              <option value="">Все</option>
              <%
                for (ReasonType type : types) {
              %>
                <option value="<%= type.getId()%>"> <%= type.getName()%> </option>
              <%
                }
              %>
            </select>
          </div>
        </div>
        <%
          if (admin) {
        %>
        <div class="form-group row">
          <div class="offset-sm-2 col-sm-6">
            <button type="submit" class="btn btn-outline-primary btn-sm"
                    onclick="if((document.f1.name.value == '')
                    || (document.f1.elements.reason_object_id.value == '')
                    || (document.f1.elements.reason_type_id.value == ''))
                    { alert('Задайте имя, объект и тип причины отклонения');
                    return(false); };"><%= RUEN.equals("RU") ? "Создать" : "Create"%>
            </button>
          </div>
        </div>
        <%
          }
        %>
      </form>
    </div>
    <div class="col-1">
    </div>
    <div class="col">
      <form name="f2" action="/reason/createType" method="post">
        <div class="form-group row">
          <label for="nameInput2"
                 class="col-sm-2 col-form-label col-form-label-sm"><%= RUEN.equals("RU") ? "Новый тип" : "New type"%>
          </label>
          <div class="col-sm-4">
            <input class="form-control form-control-sm" type="text" name="name" id="nameInput2" value="">
          </div>
            <%
                if (admin) {
            %>
          <div class="col-sm-4">
          <button type="submit" class="btn btn-outline-primary btn-sm" onclick="if(document.f2.name.value == '') { alert('Введите название типа'); return(false); };">
              <%= RUEN.equals("RU") ? "Создать" : "Create"%>
          </button>
          </div>
            <%
                }
            %>
        </div>
        <div class="form-group row">
          <div class="offset-sm-2  col-sm-5">

            1. По умолчанию <br>
            <%
              for (ReasonType type : types) {
                if(type.getNmb()>1) {
            %>
            <%= type.getName()%>
            <%
              if(admin)
              {
                req = "select count(*) from dbo.vd_reason r where r.reason_type_id = '" + type.getId() +"' and r.archive=0";
                rs = stmt.executeQuery(req);
                Integer row = 0;
                if(rs.next()) row = Integer.parseInt(rs.getString(1));
                if (row == 0) {
            %>
            <a style="text-decoration: none" href="/reason/deleteType?id=<%= type.getId()%>"
               onclick="return confirm('Удалить тип \'<%= type.getName()%>\'?')">[x]</a>
            <%
                }
              }
            %><br> <%
              }}
          %>
          </div>
        </div>
      </form>
    </div>
  </div>
</div>

<table width="100%" border="0" cellspacing="10" cellpadding="0">
<tr><td>
  <table cellspacing="1" width="100%" class="table_style_2">
  <tr align=center>
  <td class="th_style_2">#</td>
    <% if (objectFilterEnabled) { %>
    <td class="th_style_2">Сортировка</td>
    <% } %>
  <td class="th_style_2">Техническое<br/>название</td>
  <td class="th_style_2"></td>
  <td class="th_style_2">Объекты/сортировка</td>
  <td class="th_style_2">Тип</td>
  <td class="th_style_2">Описание</td>
  <td class="th_style_2">Площадки</td>
  <td class="th_style_2">География</td>
  <td class="th_style_2">Действия</td>
  </tr>
<%
  for (Reason reason : reasons) {
    n++;

    final String id = reason.getId();
    final String name = reason.getName();

    final String site;
    if (reason.getSites() != null) {
      site = reason.getSites().stream().map(Site::getName).collect(Collectors.joining("<br>"));
    } else {
      site = "";
    }

    final String geo;
    if (reason.getGeos() != null) {
      geo = reason.getGeos().stream().map(Geo::getName).collect(Collectors.joining("<br>"));
    } else {
      geo = "";
    }
%>
<script>
function check_sort(n)
{
  s = "" + eval("reasonf" + n + ".sort.value");
  symb = "0123456789";
  i = 0;
  er = false;
  while(i < s.length)
  {
    c = s.substring(i, i + 1);
    if(symb.indexOf(c) == -1) er = true;
    i ++;
  }

  if(er)
  {
    alert('Недопустимый символ в поле сортировка');
    return(false);
  }

  return(true);
}
</script>

  <form name="reasonf<%= n%>" action="/reason/sort" onsubmit="return check_sort(<%= n%>);" id="reasonf" method="post">
  <input type="hidden" name="id" value="<%= id%>">
  <input type="hidden" name="reason_object_id" value="<%= reason_object_id%>">
  <input type="hidden" name="reason_type_id" value="<%= reason_type_id%>">

  <tr align=center>
  <td class="cell_style_2"> <%= n%> </td>
    <%
      if (admin && objectFilterEnabled) {
        final ReasonObjectLink reasonObjectLink = reason.getObjectLinkByObjectId(reasonObjectId);
    %>
    <td class="cell_style_2">
      <nobr>
        <input name="sort" type="text" value="<%= reasonObjectLink.getSort()%>" class="small_font" style="width:30">
        <button type="submit" name="reason_object_link_nmb" value="<%= reasonObjectLink.getNmb() %>"
                class="small_font">Ok
        </button>
      </nobr>
    </td>
    <%
      }
    %>
  <td class="cell_style_2" align=left> <A href="reason.jsp?id=<%= id%>"> <%= reason.getModeratorName()%> </A></td>
  <td class="cell_style_2"> <%=  reason.getRuen()%> </td>
  <td class="cell_style_2">
    <table cellspacing="0" width="100%" class="table_style_2">
      <%
        for (ReasonObjectLink reasonObjectLink : reason.getObjectLinks()) {
      %>
      <tr>
        <td class="cell_style_2"><%= reasonObjectLink.getReasonObjectName()  %>
        </td>
        <td class="cell_style_2"><%= reasonObjectLink.getSort()  %>
        </td>
      </tr>
      <%}%>
    </table>
  </td>
  <td class="cell_style_2"> <nobr> <%= reason.getReasonTypeName()%> </td>
  <td class="cell_style_2" align=left><b>Публичное название</b><br/><%= name%><br/><br/><b>Полное описание</b><br/><%= reason.getText()%> </td>
  <td class="cell_style_2"> <%= site%> </td>
  <td class="cell_style_2"> <%= geo%> </td>
  <td class="cell_style_2"> 
<%
    if(admin)
    {
%>
    <a href="/reason/delete?id=<%= id%>" ONCLICK="return confirm('Удалить причину \'<%= name%>\'?')">Удалить</a>
<%
    }
%>
  </td>
  </tr>

  </form>
<%
  }
%>
  </table>
</td></tr>
<%
  stmt.close();
%>
</table>
<%@ include file="../include/admin_bottom_utf.jsp" %>
<%@ include file="../include/bottom_ssi.jsp" %>