modules.define('resize', [
    'i-bem__dom',
    'jquery',
    'functions__debounce',
    'BEMHTML'
], function(provide, BEMDOM, $, debounce, BEMHTML) {

    var SEPARATOR = '×';

    BEMDOM.decl('resize', {
        onSetMod: {
            js: {
                inited: function() {

                    var Creative = Backbone.Model.extend({
                        defaults: {
                            width: 0,
                            height: 0,
                            isResizing: false
                        }
                    });

                    this._model = new Creative();

                    ['toolbar', 'area', 'frame', 'size', 'controls'].reduce(function(prev, cur) {
                        prev['_' + cur] = prev.elem(cur);
                        return prev;
                    }, this);

                    this._frame.prop('src', this.params.url);

                    if (this.params.minWidth ||
                        this.params.minHeight ||
                        this.params.maxWidth ||
                        this.params.maxHeight
                       ) {

                        BEMDOM.append(this._controls, BEMHTML.apply(this._getRadioControll()));

                        this._rgroup = this.findBlockInside('controls', 'radio-group');
                        this._rgroup.on('change', this._onRgroupChange, this);
                    }

                    window.jQuery(this._area).resizable({
                        minWidth: this.params.minWidth,
                        minHeight: this.params.minHeight,
                        maxWidth: this.params.maxWidth,
                        maxHeight: this.params.maxHeight,
                        resize: this._onResize.bind(this),
                        start: this._onStart.bind(this),
                        stop: this._onStop.bind(this),
                    });

                    this._model.on('change:width change:height', this._updateSizeText, this);
                    this._model.on('change:isResizing', this._onResizeStartStop, this);

                    this._model.set({
                        width: this.params.width,
                        height: this.params.height,
                    });

                    this._checkRadio();
                    this._setAreaSize();
                }
            }
        },

        _onResizeStartStop: function() {
            var isResizing = this._model.get('isResizing');
            this.toggleMod(this._frame, 'resize', 'yes', '', isResizing);
            if (!isResizing && this._rgroup) {
                this._checkRadio();
            }
        },

        _setAreaSize: function() {

            this._area.css({
                width: this._model.get('width'),
                height: this._model.get('height'),
            });
        },

        _checkRadio: function() {
            var width = this._model.get('width');
            var height = this._model.get('height');
            var undef;
            this._rgroup.setVal(undef);
            this._rgroup.setVal(width + SEPARATOR + height);
        },

        _onRgroupChange: function(evt) {
            var target = evt.target;
            var value = target.getVal();

            if (typeof value !== 'undefined') {
                var splt = value.split(SEPARATOR);

                this._model.set({
                    width: parseInt(splt[0], 10),
                    height: parseInt(splt[1], 10)
                });

                this._setAreaSize();
            }
        },

       _onStart: function() {
            this._model.set('isResizing', true);
        },

        _onStop: function() {
            this._model.set('isResizing', false);
        },

        _onResize: function(evt, ui) {
            this._model.set({
                width: ui.size.width,
                height: ui.size.height
            });
        },

        _updateSizeText: function() {
            this._size.text(this._model.get('width') + SEPARATOR + this._model.get('height') + 'px');
        },

        _getRadioControll: function() {
            var bemjson = {
                block : 'radio-group',
                mods : { theme : 'islands', size : 'm', type : 'button' },
                name : 'radio-button',
                options: []
            };

            if (this.params.minWidth || this.params.minHeight) {
                bemjson.options.push({
                    val: [
                        (this.params.minWidth || this.params.width),
                        (this.params.minHeight || this.params.height)
                    ].join(SEPARATOR),
                    text: 'Минимальный размер'
                });
            }

            if (this.params.maxWidth || this.params.maxHeight) {
                bemjson.options.push({
                    val: [
                        (this.params.maxWidth || this.params.width),
                        (this.params.maxHeight || this.params.height)
                    ].join(SEPARATOR),
                    text: 'Максимальный размер'
                });
            }

            return bemjson;
        }
    });

    provide(BEMDOM);
});
