modules.require(['i-bem__dom', 'BEMHTML', 'jquery', 'resize'], function(BEMDOM, BEMHTML, $) {
    window.reloadPreview = function() {
        var getBemHtml = function(data, type) {
            var areaContent = [
                {
                    elem: 'frame',
                    tag: 'iframe'
                }
            ];
            // расписываем большой баннер
            if (type === 'big') {
                areaContent.push({
                    block: 'popup',
                    tag: 'div',
                    attrs:{
                        id : "popup_big"
                    },
                    content: [
                        'Обработчик закрытия баннера',
                        {
                            tag: 'span',
                            cls: 'not',
                            content: ' не'
                        },
                        ' отработан.'
                    ]
                });
            }
            return [
                {
                    block: 'resize',
                    js: data,
                    content: [
                        {
                            elem: 'toolbar',
                            content: [
                                {
                                    elem: 'controls'
                                },
                                {
                                    elem: 'size'
                                }
                            ]
                        },
                        {
                            elem: 'area',
                            content: areaContent
                        }
                    ]
                },
                {
                    block : 'button',
                    mods : { theme : 'islands', size : 'm', type : 'submit' },
                    name : 'btn-play',
                    cls : 'btn-play margin10px',
                    text : 'Reset / Play'
                },
                {
                    block : 'button',
                    mods : { theme : 'islands', size : 'm', type : 'submit' },
                    name: 'btn-pause',
                    cls : 'btn-pause margin10px',
                    text : 'Pause'
                }
            ];
        };

        var $html5_small = $('#html5_small');
        var $html5_big = $('#html5_big');

        $html5_small.html(BEMHTML.apply(getBemHtml($html5_small.data(), 'small')));
        $html5_big.html(BEMHTML.apply(getBemHtml($html5_big.data(), 'big')));

        $html5_small.append("<div class='clock margin10px' id='clock_small'></div>");
        $html5_big.append("<div class='clock margin10px' id='clock_big'></div>");

        $html5_small.find('.btn-play').bind('click',function(event) {
            var now = new Date().getTime();
            $('#clock_small').countdown(now, {elapse: true});
            $('#clock_small').countdown('start');
        });

        $html5_small.find('.btn-pause').bind('click',function(event) {
            $('#clock_small').countdown('stop')
        });

        $html5_big.find('.btn-play').bind('click',function(event) {
            var now = new Date().getTime();
            $('#clock_big').countdown(now, {elapse: true});
            $('#clock_big').countdown('start');
        });

        $html5_big.find('.btn-pause').bind('click',function(event) {
            $('#clock_big').countdown('stop')
        });

        var now = new Date().getTime();
        $('.clock').countdown(now, {elapse: true})
            .on('update.countdown', function(event) {
                $(this).html(event.strftime('<b>%H:%M:%S</b>'));
            });
    };

    window.reloadPreview();
});
