modules.require(['i-bem__dom', 'BEMHTML', 'jquery', 'resize'], function(BEMDOM, BEMHTML, $) {
    var $app = $('#app');
    var data = $app.data();
    var html = BEMHTML.apply([
        {
            block: 'resize',
            js: data,
            content: [
                {
                    elem: 'toolbar',
                    content: [
                        {
                            elem: 'controls'
                        },
                        {
                            elem: 'size'
                        }
                    ]
                },
                {
                    elem: 'area',
                    content: [
                        {
                            elem: 'frame',
                            tag: 'iframe'
                        },
                        {
                            block: 'popup',
                            tag: 'div',
                            attrs:{
                                id : "popup_big"
                            },
                            content: [
                                'Обработчик закрытия баннера',
                                {
                                    tag: 'span',
                                    cls: 'not',
                                    content: ' не'
                                },
                                ' отработан.'
                            ]
                        }
                    ]
                }
               ]
        }
    ]);

    BEMDOM.append($app, html);

    $(window).on('message', function (event) {
        event = event.originalEvent;
        var msg;
        try {
            msg = JSON.parse(event.data);
        } catch (err) {
            return;
        }
        if (msg && msg.command && msg.command === 'close') {
            var popup = document.querySelector('.popup');
            popup.classList.add('active');
        }
    });
});
