// Пересобирает url, заменяя и добавляя значения query-параметров, переданные в overrideParams
// Например, rebuildUrl('http://yandex.ru?video=3&link1=5', {'link1': '0', 'link2': '1'})
// вернёт 'http://yandex.ru?video=3&link1=0&link2=1'
// Значения-массивы не поддерживаются (вида '?param=value_1&param=value_2')
function overrideQueryParameters(url, params) {
    var resultUrl;
    var newParams;
    var urlParts = {};
    if (-1 == url.indexOf('?') && -1 == url.indexOf('=')) {
        resultUrl = url;
        newParams = params;
    } else {
        // Проверка на случай, если переданы исключительно query-параметры без урла
        if (-1 == url.indexOf('?') && -1 != url.indexOf('=')) {
            urlParts = ['', url]
        }
        else {
            urlParts = url.split('?');
        }
        resultUrl = urlParts[0];
        newParams = {};
        urlParts[1].split('&').forEach(function (param) {
            if (param.length != 0) {
                var parts = param.split('=');
                if (!params.hasOwnProperty(parts[0])) {
                    newParams[parts[0]] = decodeURIComponent(parts[1]);
                } else {
                    newParams[parts[0]] = params[parts[0]] + "&originalValue=" + encodeURIComponent(parts[1]);
                }
            }
        });
        if (Object.keys(params).length != 0) {
            for (var param in params) {
                if (!newParams.hasOwnProperty(param)) {
                    newParams[param] = params[param];
                }
            }
        }
    }
    if (Object.keys(newParams).length != 0) {
        var first = true;
        for (var p in newParams) {
            if (newParams.hasOwnProperty(p)) {
                if (first) {
                    if (urlParts[0] || resultUrl) {
                        resultUrl += '?';
                    }
                } else {
                    resultUrl += '&';
                }
                first = false;
                resultUrl += p + '=' + encodeURIComponent(newParams[p]);
            }
        }
    }
    return resultUrl;
}

// Джоинит url с переданной строкой-params с query-параметрами
// Например, addQueryParams('http://yandex.ru?video=3&link1=5', 'link2=423423&link3=3453453')
// вернёт 'http://yandex.ru?video=3&link1=5&link2=423423&link3=3453453'
// Поддерживаются только входные данные типа строка
function addQueryParams(url, params) {
    var resultUrl;
    var urlParts = {};
    // проверяем, что у урла изначально нет query-params
    if (-1 == url.indexOf('?') && -1 == url.indexOf('=')) {
        resultUrl = url;

    } else { // есть query-params
        urlParts = url.split('?');
        resultUrl = urlParts[0];
    }
    // на случай если строка с переданными параметрами содержит ? или & вначале
    if (params.charAt(0) == "?" || params.charAt(0) == "&") {
        params = params.substr(1);
    }
    resultUrl = resultUrl + "?"

    if (urlParts[1]) {
        resultUrl = resultUrl + urlParts[1] + "&";
    }
    return resultUrl + params;
}
