(function(Lego){
if (!Lego) Lego = window.Lego = {};
/**
 * Проверяет жива ли сессия пользователя (наличие и время жизни куки
 * Session_id).
 *
 * <a href="https://wiki.yandex.ru/passport/sessionid">wiki.yandex.ru/passport/sessionid</a>
 *
 * @return  true, если сессия пользователя живая.
 */
Lego.isSessionValid = function() {
    var sid = Lego.getCookie('Session_id');
    if (!sid) return false;

    var parts = sid.split('.');
    if (parts[2] == '1') return true;

    var d = parseFloat(((new Date().getTime()) - parts[0] * 1000 - parts[1]) / 1000);
    if (parts[2] == '3') return d < 1209600;

    return d < 7200;
}
})(window.Lego);
